var tabla;
function init(){
    listar_pago();

    $("#frmForm").on("submit", function(e) {
      guardaryeditar_egreso(e);
    });
    
    const params = new URLSearchParams(window.location.search);
    const tipoParam = params.get("tipo");
    const idcategoria_egreso = params.get("idcategoriaegreso");
    const idconcepto_egreso = params.get("idconceptoegreso");


   // Evento cuando se selecciona un valor en el select de "tipo"
       $(document).ready(function () {
  // Evento cuando el usuario selecciona un valor manualmente
            $("#tipo").change(function () {
              var tipo = $(this).val();

              $.post("../../ajax/categoriaegreso.php?op=selectCategoriaEgresoTipo&tipo=" + tipo, function (r) {
                if ($.fn.select2 && $('#idcategoria_egreso').data('select2')) {
                  $('#idcategoria_egreso').select2('destroy');
                }

                $("#idcategoria_egreso").html('<option value="">Seleccione una Categoria</option>');
                $("#idcategoria_egreso").append(r);

                $('#idcategoria_egreso').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione una Categoria',
                  allowClear: true,
                });
             if (idcategoria_egreso) {
                $("#idcategoria_egreso").val(idcategoria_egreso).trigger("change");
              }
              });
            });

            if (tipoParam) {
              $("#tipo").val(tipoParam).trigger("change");
            }
          });

        $(document).on("change", "#idcategoria_egreso", function() {
          var idcategoria_egreso = $(this).val(); // Obtener el ID seleccionado
          //console.log(idcategoria_egreso);
          // Restablecer el select de idconcepto_egreso
          $("#idconcepto_egreso").html('<option value="">Seleccione Tipo Egreso</option>');
      
          // Hacer la solicitud AJAX para cargar las opciones del concepto de egreso
          $.post("../../ajax/categoriaegreso.php?op=selectConceptoEgreso&idcategoria_egreso=" + idcategoria_egreso, function(r) {
              if ($.fn.select2 && $('#idconcepto_egreso').data('select2')) {
                  $('#idconcepto_egreso').select2('destroy'); // Destruir Select2 si ya está inicializado
              }
      
              // Actualizar las opciones
              $("#idconcepto_egreso").html('<option value="">Seleccione una Concepto</option>'); 
              $("#idconcepto_egreso").append(r);
      
              // Inicializar Select2 nuevamente
              $('#idconcepto_egreso').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Concepto',
                  allowClear: true,
              });
              if (idconcepto_egreso) {
                $("#idconcepto_egreso").val(idconcepto_egreso).trigger("change");
              }
          });
      });

      $(document).ready(function () {
        // Obtener el parámetro idegreso de la URL
        const urlParams = new URLSearchParams(window.location.search);
        const idegreso = urlParams.get("idegreso"); // Si es null, estamos en "create.php" (modo creación)
      
        if (!idegreso) { // 🔹 Solo ejecuta el "change" si NO estamos editando
          $("#idconcepto_egreso").on("change", function () {
            var idconcepto_egreso = $("#idconcepto_egreso").val(); // Obtener el ID del plan seleccionado
            if (idconcepto_egreso) {
              // Hacer la solicitud AJAX para traer los datos del plan
              $.post("../../ajax/categoriaegreso.php?op=obtenerDatosConcepto&id=" + idconcepto_egreso, function (data, status) {
                if (status === "success") {
                  const response = JSON.parse(data);
                  if (response.conceptos && response.conceptos.length > 0) {
                    const planData = response.conceptos[0];
                    let cuotatotal= planData.cuotas;
                    let numerocuota = planData.numero_cuota;
                    $("#monto_concepto").val(planData.monto);
                    $("#fechavencimiento").val(planData.fechavencimiento);
                    $("#archivador").val(planData.archivador);
                    $("#folio").val(planData.folio);
                    $("#cuota").val(numerocuota + "/" + cuotatotal);
                    $("#descripcion_concepto").val(planData.descripcion);
                    $("#descripcion").val(planData.descripcion);
                    $("#iddetalle_egreso").val(planData.iddetalle_egreso);
                    $("#mes_anterior").val(planData.mes_anterior);
                    $("#precio_luz").val(planData.precio_luz);
                    $("#nombre_pago").val(planData.nombre_pago);
                    $("#descripcion_pago").val(planData.descripcion_pago);
                  }
                }
              }).fail(function () {
                alert("Error al obtener los datos del plan. Intente nuevamente.");
              });
            } else {
              // Limpiar los inputs si no hay plan seleccionado
              $("#monto_concepto, #fechavencimiento, #archivador, #folio, #cuota, #descripcion_concepto, #iddetalle_egreso, #mes_anterior, #mes_actual, #precio_luz, #nombre_pago, #descripcion_pago").val('');
            }
          });
        }
      });

      $.post("../../ajax/banco.php?op=selectbanco", function(r){
        if ($.fn.select2 && $('#idbanco').data('select2')) {
          $('#idbanco').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idbanco").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idbanco').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un banco',
          allowClear: true,
        });
      });

      $.post("../../ajax/usuario.php?op=selectUsuario", function(r){
        if ($.fn.select2 && $('#idresponsable').data('select2')) {
          $('#idresponsable').select2('destroy');
        }
      
        // Actualizar el contenido del select
        $("#idresponsable").html('<option value="">Seleccione un Usuario</option>'); 
        $("#idresponsable").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idresponsable').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un usuario',
          allowClear: true,
        });
      });

    
}

function mostrarOcultarCampos() {
  const radioEfectivo = document.getElementById("radioEfectivo");
  const campoBanco = document.getElementById("campoBanco");
  const campoOperacion = document.getElementById("campoOperacion");
  const idBanco = document.getElementById("idbanco");
  const nroOperacion = document.getElementById("nro_operacion");

  // Mostrar u ocultar campos y gestionar el atributo requerido
  if (radioEfectivo.checked) {
      campoBanco.style.display = "none";
      campoOperacion.style.display = "none";
      idBanco.removeAttribute("required");
      nroOperacion.removeAttribute("required");
  } else {
      campoBanco.style.display = "block";
      campoOperacion.style.display = "block";
      idBanco.setAttribute("required", "required");
      nroOperacion.setAttribute("required", "required");
  }
}

$(document).ready(function () {
  // Ocultar los campos al cargar la página
  $("#mes_anterior, #mes_actual, #precio_luz").closest('.col-12').hide();

  // Detectar cambios en el select de categoría
  $("#idcategoria_egreso").on("change", function () {
      let selectedValue = $(this).val();
      
      if (selectedValue == "16") {
          // Mostrar los campos cuando la categoría es '4'
          $("#mes_anterior, #mes_actual, #precio_luz").closest('.col-12').show();
      } else {
          // Ocultar los campos y limpiar valores si es otra categoría
          $("#mes_anterior, #mes_actual, #precio_luz").val("").closest('.col-12').hide();
      }
  });

  // Función para calcular el monto_concepto
  function calcularMonto() {
      let mesAnterior = parseFloat($("#mes_anterior").val()) || 0;
      let mesActual = parseFloat($("#mes_actual").val()) || 0;
      let precioLuz = parseFloat($("#precio_luz").val()) || 0;

      if (mesActual >= 0 && mesAnterior >= 0 && precioLuz >= 0) {
          let monto = (mesActual - mesAnterior) * precioLuz;
          $("#monto_concepto").val(monto.toFixed(2)); // Redondeo a 2 decimales
      }
  }

  // Detectar cambios en los campos y recalcular automáticamente
  $("#mes_anterior, #mes_actual, #precio_luz").on("input", calcularMonto);
});
//Función limpiar
function limpiar()
{
    $("#idbanco").val("");
  	$("#descripcion").val("");
    $("#monto").val("");
    $("#nrorecibo").val("");
    $("#nro_operacion").val("");

}
// Función para listar datos
function listar_pago() {
    tabla=$("#pagar_egreso").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/categoriaegreso.php?op=listar_pago',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar_egreso(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/categoriaegreso.php?op=guardaryeditar_egreso",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Pago Registrado") || datos.includes("Pago Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Pago Registrado") || datos.includes("Pago Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function eliminar_egreso(idegreso) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/categoriaegreso.php?op=eliminar_egreso", { idegreso: idegreso }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El banco ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El banco está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idbanco de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idegreso = urlParams.get('idegreso');

  if (idegreso) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/categoriaegreso.php?op=mostrar_egreso", { idegreso: idegreso }, function (data, status) {
          if (status === "success") {
              const response = JSON.parse(data);
            if (response.egresos && response.egresos.length > 0) {
              const egreso = response.egresos[0];
              let tipoVenta = egreso.tipopago;
              let cuotatotal= egreso.cuotas;
              let numerocuota = egreso.numero_cuota;
               if (numerocuota && !isNaN(numerocuota) && Number(numerocuota) > 0) {
                  numerocuota = egreso.numero_cuota;
                } else {
                  numerocuota = '0';
                }
              // Precargar los campos del formulario
              $("#idegreso").val(egreso.idegreso);
              $("#descripcion").val(egreso.descripcion);
              $("#monto").val(egreso.monto);
              $("#hora").val(egreso.hora);
              $("#fechapago").val(egreso.fechapago);
              $("#nrorecibo").val(egreso.nrorecibo);
              $("#descripcion_concepto").val(egreso.descripcion_concepto);
              $("#monto_concepto").val(egreso.monto);
              $("#fechavencimiento").val(egreso.fechavencimiento);
              $("#mes_actual").val(egreso.mes_actual);
              $("#mes_anterior").val(egreso.mes_anterior);
              $("#precio_luz").val(egreso.precio_luz);
              $("#archivador").val(egreso.archivador);
              $("#folio").val(egreso.folio);
              $("#cuota").val(numerocuota + "/" + cuotatotal);
              $("#nombre_pago").val(egreso.nombre_pago);
              $("#descripcion_pago").val(egreso.descripcion_pago);
              $("#iddetalle_egreso").val(egreso.iddetalle_egreso);

              setTimeout(function () {
                $("#tipo").val(egreso.tipo).trigger('change'); // Primer select
                  setTimeout(function () {
                  $("#idcategoria_egreso").val(egreso.idcategoria_egreso).trigger('change'); // Primer select
                  setTimeout(() => {
                    $("#idconcepto_egreso").val(egreso.idconcepto_egreso).trigger('change');
                    }, 200);
                   }, 200);
                 }, 300);


              if (tipoVenta == '2') {
                $("#radioEfectivo").prop("checked", true);
               mostrarOcultarCampos();
            } else if (tipoVenta == '3') {
                $("#radioDeposito").prop("checked", true);
              mostrarOcultarCampos();
              $("#nro_operacion").val(egreso.nroperacion);
              $("#idbanco").val(egreso.idbanco).trigger("change");
            }

            setTimeout(function () {
              $("#comprobante").val(egreso.tipo_comprobante).trigger('change'); // Primer select
                setTimeout(function () {
                $("#idresponsable").val(egreso.idtecnico).trigger('change'); // Primer select
                 }, 200);
               }, 300);

              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Pago Egreso')

            }else{
              console.error("No se encontraron datos para el egreso.");
            }
          } else {
              console.error("Error al cargar los datos");
          }


      });
  }
});

init();