var tabla;
function init(){
    listar();
    listar_pendiente_actualizar();


    $("#fmrimagen").on("submit", function(e) {
        guardarImagen(e); // Llamar a la función para procesar el formulario
      });

    $.post("../../ajax/banco.php?op=selectbanco", function(r){
        if ($.fn.select2 && $('#idbanco').data('select2')) {
          $('#idbanco').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idbanco").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idbanco').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un banco',
          allowClear: true,
        });
      });
    
}

const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

function guardarImagen(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnImagen").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#fmrimagen")[0]);
  
    // Configuración de alerta de confirmación
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Mostrar alerta de carga con spinner
        // Realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/consulta.php?op=guardarImagen",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
          
          if (datos.includes("Registro Actualizado") || datos.includes("Actualizar")) {
            let timerInterval;
            Swal.fire({
              title: "Guardando...",
              html: "Por favor, espera mientras se procesan los datos.",
              timer: 5000, // 10 segundos de espera
              timerProgressBar: true,
              allowOutsideClick: false, // Desactiva interacciones externas
              backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
              didOpen: () => {
                Swal.showLoading(); // Mostrar spinner de carga
              },
              willClose: () => {
                clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
                $(location).attr("href", "list_pago_verificar.php");
              }
            });
          }else{
            let timerInterval;
            Swal.fire({
                position: 'center',
                title: "Error",
                html: "Datos no pudieron ser procesadas.<br>Cerrando en <b></b> ms.",
                icon: "error",
                timer: 2000,
                timerProgressBar: true,
                allowOutsideClick: false, // Desactiva interacciones externas
                backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                customClass: {
                    popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                },
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Swal.getTimerLeft()}`;
                    }, 100);
                },
                willClose: () => {
                  $(location).attr("href", "list_pago_verificar.php");
                }
            });
          }
          },
          error: function () {
            // Manejar errores en la solicitud AJAX
            Swal.close();
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: "Hubo un problema con la solicitud. Intente nuevamente.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              $("#btnImagen").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnImagen").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    });
  }

function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/consulta.php?op=listar_pago',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function mostrar_imagen(idverificar){
//console.log(idverificar);
  if (idverificar) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/consulta.php?op=mostrar_imagen", { idverificar: idverificar }, function (data, status) {
          if (status === "success") {

            const response = JSON.parse(data);
            if (response.cabeceras && response.cabeceras.length > 0) {
              const consulta = response.cabeceras[0];
              // Precargar los campos del formulario
              $("#idverificar").val(consulta.idverificar);
              $("#nroperacion").val(consulta.nroperacion);
              $("#fecha").val(consulta.fecha);
              $("#hora").val(consulta.hora);
              $("#imagenvoucher").show();
              $("#imagenvoucher").attr("src","../../files/voucher/"+consulta.imagen);
              $("#imagenactual").val(consulta.imagen);
              $("#idbanco").val(consulta.banco).trigger("change");
            }

          } else {
              console.error("Error al cargar los datos");
          }

        });

    }else{

    }
}

function eliminar(idverificar) {
    const swalWithBootstrapButtons = Swal.mixin({
      customClass: {
        confirmButton: "btn btn-success mx-2",
        cancelButton: "btn btn-danger mx-2"
      },
      buttonsStyling: false
    });
  
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¡No podrás revertir esto!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, eliminar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Realizar la eliminación vía AJAX
        $.post("../../ajax/consulta.php?op=eliminar", { idverificar: idverificar }, function (e) {
          swalWithBootstrapButtons.fire({
            title: "Eliminado",
            text: "El Pago ha sido eliminada exitosamente.",
            icon: "success"
          });
  
          // Recargar la tabla después de eliminar
          tabla.ajax.reload();
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "El Pago está segura :)",
          icon: "error"
        });
      }
    });
  }

  function pagar_cuota(idverificar) {
    // Configuración de alerta de confirmación
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        let formData = new FormData();
        formData.append("idverificar", idverificar);  // Agregar idverificar al FormData
        // Realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/consulta.php?op=pagar_cuota&idverificar=" + encodeURIComponent(idverificar), // Pasar idverificar en la URL
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
          
          if (datos.includes("Cuota Cancelada")) {
            let timerInterval;
            Swal.fire({
              title: "Guardando...",
              html: "Por favor, espera mientras se procesan los datos.",
              timer: 5000, // 10 segundos de espera
              timerProgressBar: true,
              allowOutsideClick: false, // Desactiva interacciones externas
              backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
              didOpen: () => {
                Swal.showLoading(); // Mostrar spinner de carga
              },
              willClose: () => {
                clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
                $(location).attr("href", "list_pago_verificar.php");
              }
            });
          }else if (datos.includes("No puedes volver a pagar la misma cuota")) {
            swalWithBootstrapButtons.fire({
              title: "Advertencia",
              text: datos,
              icon: "warning",
              confirmButtonText: "Aceptar"
            });
          }else{
            let timerInterval;
            Swal.fire({
                position: 'center',
                title: "Error",
                html: "Datos o nroperacion duplicado.<br>Cerrando en <b></b> ms.",
                icon: "error",
                timer: 2000,
                timerProgressBar: true,
                allowOutsideClick: false, // Desactiva interacciones externas
                backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                customClass: {
                    popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                },
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Swal.getTimerLeft()}`;
                    }, 100);
                },
                willClose: () => {
                  $(location).attr("href", "list_pago_verificar.php");
                }
            });
          }
          },
          error: function () {
            // Manejar errores en la solicitud AJAX
            Swal.close();
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: "Hubo un problema con la solicitud. Intente nuevamente.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
             // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
         // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    });
  }
  
  function listar_pendiente_actualizar() {
    tabla=$("#pendiente").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/consulta.php?op=listar_pendiente_actualizar',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function actualizar_procesados(event) {
   event.preventDefault();


    swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas actualizar las líneas?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, realizar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: "Procesando...",
                text: "Esto puede tardar varios minutos.",
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                backdrop: true,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: "../../ajax/consulta.php?op=actualizar_procesados",
                type: "POST",
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);

                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Proceso completado",
                                html: `Se procesaron ${datos.procesados} líneas.<br>Se actualizaron ${datos.actualizados} líneas.`,
                                icon: "success",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                willClose: () => {
                                    $(location).attr("href", "pendiente_actualizar.php");
                                }
                            });
                        } else {
                            Swal.fire({
                                title: "Error",
                                text: "Hubo un problema en la actualización.",
                                icon: "error",
                                confirmButtonText: "Aceptar"
                            });
                        }
                    } catch (error) {
                        console.error("Error al procesar respuesta:", error);
                        Swal.fire({
                            title: "Error",
                            text: "Respuesta inesperada del servidor.",
                            icon: "error",
                            confirmButtonText: "Aceptar"
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema con la solicitud. Intente nuevamente.",
                        icon: "error",
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }
    });
}

init();