var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/tecnologia.php?op=selectTecnologia", function(r){
      if ($.fn.select2 && $('#idtecnologia').data('select2')) {
        $('#idtecnologia').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idtecnologia").html('<option value="">Seleccione Tecnologia</option>');
      // Actualizar el contenido del select
       $("#idtecnologia").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idtecnologia').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una tecnologia',
        allowClear: true,
      });
    });

    $.post("../../ajax/olt.php?op=selectOlt", function(r){
      if ($.fn.select2 && $('#idolt').data('select2')) {
        $('#idolt').select2('destroy');
      }
    
       // Actualizar el contenido del select
       $("#idolt").html('<option value="">Seleccione Torre</option>');
       // Actualizar el contenido del select
         $("#idolt").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idolt').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una olt',
        allowClear: true,
      });
    });
    
    $('#idolt').on('change', function () {
      // Obtener la opción seleccionada
      var selectedOption = $(this).find('option:selected');

      // Obtener el atributo personalizado
      var idtorre = selectedOption.data('idtorre');

      console.log("ID Torre seleccionado:", idtorre);

      // Si lo necesitas guardar en un input oculto o variable
      $('#idtorre').val(idtorre); // si tienes un <input type="hidden" id="idtorre">
    });

}
//Función limpiar
function limpiar()
{
    $("#idplan").val("");
    $("#nombre_plan").val("");
    $("#idtecnologia").val("");
    $("#idolt").val("");
    $("#precio").val("");
    $("#descripcion").val("");
    $("#upload_servicio").val("");
    $("#download_servicio").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/plan.php?op=listarplan',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar la acción predeterminada del formulario
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar envíos múltiples
  var formData = new FormData($("#frmForm")[0]);


  // Mostrar la alerta de confirmación
  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, hacer la petición AJAX
      $.ajax({
        url: "../../ajax/plan.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json", // Aseguramos que el backend devuelva JSON
        success: function (response) {
          // Verificamos si la respuesta tiene un status
          if (response.status === "success") {
            Swal.fire({
              title: "Éxito",
              text: response.message,
              icon: "success",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "list.php"; // Redirigir al listado
              limpiar();
            });
          } else {
            Swal.fire({
              title: "Error",
              text: response.message || "Hubo un problema al guardar.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "create.php"; // Redirigir al formulario de creación en caso de error
            });
          }
        },
        error: function () {
          Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
          $("#btnGuardar").prop("disabled", false);
        }
      });
    } else {
      // Si el usuario cancela, mostrar mensaje
      Swal.fire("Cancelado", "No se realizaron cambios.", "error");
      $("#btnGuardar").prop("disabled", false);
    }
  }).catch(() => {
    $("#btnGuardar").prop("disabled", false); // Rehabilitar botón en caso de error
  });
}

function eliminar(idplan) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/plan.php?op=eliminar", { idplan: idplan }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El plan ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El Plan está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idolt de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idplan = urlParams.get('idplan');

  if (idplan) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/plan.php?op=mostrar", { idplan: idplan }, function (data, status) {
          if (status === "success") {
              const plan = JSON.parse(data);

              // Precargar los campos del formulario
              setTimeout(function() {
              $("#idtecnologia").val(plan.idtecnologia).trigger('change'); // Actualiza Select2
              $("#idolt").val(plan.idolt).trigger('change'); // Actualiza Select2
            }, 200);
              $("#idplan").val(plan.idplan);
              $("#nombre_plan").val(plan.nombre_plan);
              $("#precio").val(plan.precio);
              $("#descripcion").val(plan.descripcion);
              $("#upload_servicio").val(plan.upload_servicio);
              $("#download_servicio").val(plan.download_servicio);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Plan')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

init();