var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/categoria.php?op=selectCategoria", function(r){
      if ($.fn.select2 && $('#idcategoria').data('select2')) {
        $('#idcategoria').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idcategoria").html(r);
    
      // Inicializar Select2 nuevamente
      $('#idcategoria').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una categoría',
        allowClear: true,
      });
    });
 

    $("#imagenmuestra").hide();
}
//Función limpiar
function limpiar()
{
    $("#idarticulo").val("");
    $("#nombre").val("");
    $("#idcategoria").val("");
    $("#unidadmedida").val("");
  	$("#descripcion").val("");
    $("#imagen").val("");
    $("#codigo").val("");
    $("#estado").val("");
    $("#nroproducto").val("");
    
}
// Función para listar datos
function listar() {

    
    $("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "aProcessing": true,//Activamos el procesamiento del datatables
        "ajax": {
            url: '../../ajax/producto.php?op=listarcategoria',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.log(e.responseText);
                //alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
        },
        "bDestroy": true
    });
}

function mostrarlista(idcate){
   

  $("#tblarticulos").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/producto.php?op=listarpro&id='+idcate,
          type: "GET",
          dataType: "json",
          error: function(e) {
            console.log(e.responseText);
            //alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
      },
      "bDestroy": true
  });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/producto.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Producto Registrado") || datos.includes("Producto Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Producto Registrado") || datos.includes("Producto Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idarticulo) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/producto.php?op=eliminar", { idarticulo: idarticulo }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El producto ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El producto está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idproducto de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idarticulo = urlParams.get('idarticulo');

  if (idarticulo) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/producto.php?op=mostrar", { idarticulo: idarticulo }, function (data, status) {
          if (status === "success") {
              const producto = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idarticulo").val(producto.idarticulo);
              $("#nombre").val(producto.nombre);
              setTimeout(function() {
              $("#idcategoria").val(producto.idcategoria).trigger('change'); // Actualiza Select2
            }, 200);
              $("#unidadmedida").val(producto.unidad_medida);
              $("#descripcion").val(producto.descripcion);
              $("#imagenmuestra").show();
		          $("#imagenmuestra").attr("src","../../files/articulos/"+producto.imagen);
		           $("#imagenactual").val(producto.imagen);
              $("#codigo").val(producto.codigo);
              $("#estado").val(producto.estado);
              $("#nroproducto").val(producto.nroproducto);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar producto')
              generarbarcode();
          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

function mostrarCodigoBarra(idarticulo){
	$.post("../../ajax/producto.php?op=mostrarCodigoBarra",{idarticulo:idarticulo},function(data,status){
		data = JSON.parse(data);
		$('#idarti').val(data.idarticulo);
		$('#codigob').val(data.codigo);
		codigo=$("#codigob").val()+$("#idarti").val();
		art=$("#idarti").val();
		
		JsBarcode("#barcodeb", codigo,{
			 width: 4,
  			 height: 100,
  			 // lineColor: "blue"
  			 // displayValue: false
		});
	})
}

//función para generar el código de barras
function generarbarcode()
{
	codigo=$("#codigo").val();
	JsBarcode("#barcode", codigo);
	$("#print").show();
}

//Función para imprimir el Código de barras
function imprimir()
{
	$("#print").printArea();
}
function imprimirb()
{
	$("#printb").printArea();
}

init();