var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $("#tipo").change(function () {
      var tipo  = $("#tipo").val(); // Obtener el valor seleccionado

    
          // Hacer la solicitud al servidor
          $.post("../../ajax/categoriaegreso.php?op=selectCategoriaEgresoTipo&tipo=" + tipo,  function (r) {
              if ($.fn.select2 && $('#idcategoria_egreso').data('select2')) {
                  $('#idcategoria_egreso').select2('destroy'); // Destruir select2 anterior
              }
              $("#idcategoria_egreso").html('<option value="">Seleccione una Categoria</option>'); 
              // Actualizar el contenido del select
              $("#idcategoria_egreso").append(r);

              // Inicializar Select2 nuevamente
              $('#idcategoria_egreso').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione una Categoria',
                  allowClear: true,
              });
          });
         
      });
  }
  $(document).ready(function () {
    // Ocultar los campos al cargar la página
    $("#mes_anterior,  #precio_luz").closest('.col-12').hide();
    $("#monto_total").closest('.col-12').hide();
  
    // Detectar cambios en el select
    $("#idcategoria_egreso").on("change", function () {
        let selectedValue = $(this).val();
  
        if (selectedValue == "4") {
            // Mostrar los campos si el valor seleccionado es '3'
            $("#mes_anterior,  #precio_luz").closest('.col-12').show();
        } else {
            // Ocultar los campos si es otro valor
            $("#mes_anterior,  #precio_luz").closest('.col-12').hide();
        }

        if (selectedValue == "3") {
          // Mostrar los campos si el valor seleccionado es '3'
          $("#monto_total").closest('.col-12').show();
      } else {
          // Ocultar los campos si es otro valor
          $("#monto_total").closest('.col-12').hide();
      }
    });

  });
  

//Función limpiar
function limpiar()
{
    $("#idconcepto_egreso").val("");
    $("#idcategoria_egreso").val("");
    $("#tipo").val("");
    $("#concepto").val("");
    $("#descripcion").val("");
    $("#folio").val("");
    $("#archivador").val("");
    $("#monto").val("");
    $("#cuota").val("");
    $("#fechavencimiento").val("");
    
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/registroegreso.php?op=listarregistroegreso',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/registroegreso.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Registro Egreso Registrado") || datos.includes("Registro Egreso Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Registro Egreso Registrado") || datos.includes("Registro Egreso Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idconcepto_egreso) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/registroegreso.php?op=eliminar", { idconcepto_egreso: idconcepto_egreso }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El Registro Egreso ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El Egreso está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcategoriaingreso de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idconcepto_egreso = urlParams.get('idconcepto_egreso');

  if (idconcepto_egreso) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/registroegreso.php?op=mostrar", { idconcepto_egreso: idconcepto_egreso }, function (data, status) {
          if (status === "success") {
              const egreso = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idconcepto_egreso").val(egreso.idconcepto_egreso);
              $('#cuota-container').show();
              setTimeout(function() {
              $("#idcategoria_egreso").val(egreso.idcategoria_egreso).trigger('change');
            }, 200);
              $("#tipo").val(egreso.tipo).trigger('change');
              $("#concepto").val(egreso.concepto);
              $("#descripcion").val(egreso.descripcion);
              $("#folio").val(egreso.folio);
              $("#archivador").val(egreso.archivador);
              $("#monto").val(egreso.monto);
              $("#cuota").val(egreso.cuotas);
              $("#fechavencimiento").val(egreso.fechavencimiento);
              $("#condicion").val(egreso.condicion);
              $("#precio_luz").val(egreso.precio_luz);
              $("#monto_total").val(egreso.monto_total);
              $("#nombre_pago").val(egreso.nombre_pago);
              $("#descripcion_pago").val(egreso.descripcion_pago);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Categoria Egreso')
          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});


init();