var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/categoriaingreso.php?op=selectCategoriaIngreso", function(r){
        if ($.fn.select2 && $('#idcategoria_ingreso').data('select2')) {
          $('#idcategoria_ingreso').select2('destroy');
        }
      
        // Actualizar el contenido del select
        $("#idcategoria_ingreso").html(r);
      
        // Inicializar Select2 nuevamente
        $('#idcategoria_ingreso').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un Categoria',
          allowClear: true,
        });
      });
  }

  
//Función limpiar
function limpiar()
{
    $("#idconcepto_ingreso").val("");
    $("#idcategoria_ingreso").val("");
    $("#tipo_trabajo").val("");
    $("#descripcion").val("");
    $("#folio").val("");
    $("#archivador").val("");
    $("#equivalencia").val("");
    $("#color").val("");
    
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/registroingreso.php?op=listarregistroingreso',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/registroingreso.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Registro Ingreso Registrado") || datos.includes("Registro Ingreso Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Registro Ingreso Registrado") || datos.includes("Registro Ingreso Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idconcepto_ingreso) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/registroingreso.php?op=eliminar", { idconcepto_ingreso: idconcepto_ingreso }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El Registro Ingreso ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El ingreso está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcategoriaingreso de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idconcepto_ingreso = urlParams.get('idconcepto_ingreso');

  if (idconcepto_ingreso) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/registroingreso.php?op=mostrar", { idconcepto_ingreso: idconcepto_ingreso }, function (data, status) {
          if (status === "success") {
              const ingreso = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idconcepto_ingreso").val(ingreso.idconcepto_ingreso);
              setTimeout(function() {
              $("#idcategoria_ingreso").val(ingreso.idcategoria_ingreso).trigger('change');
            }, 200);
              $("#tipo_trabajo").val(ingreso.tipo_trabajo);
              $("#descripcion").val(ingreso.descripcion);
              $("#folio").val(ingreso.folio);
              $("#archivador").val(ingreso.archivador);
              $("#equivalencia").val(ingreso.equivalencia);
              $("#precio").val(ingreso.precio);
              $("#color").val(ingreso.color);
              $("#condicion").val(ingreso.condicion);
              $(".input-group-addon i").css("background-color", ingreso.color);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Categoria Ingreso')
          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});


init();