var tabla;
function init(){

   $.post("../../ajax/tecnologia.php?op=selectTecnologia", function(r){
      if ($.fn.select2 && $('#idtecnologia').data('select2')) {
        $('#idtecnologia').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idtecnologia").html('<option value="">Seleccione Tecnologia</option>');
      // Actualizar el contenido del select
       $("#idtecnologia").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idtecnologia').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una tecnologia',
        allowClear: true,
      });
    });

       $.post("../../ajax/torre.php?op=selectTorre", function (r) {
        if ($.fn.select2 && $('#idtorre').data('select2')) {
            $('#idtorre').select2('destroy');
        }

        // Actualizar el contenido del select
        $("#idtorre").html('<option value="">Seleccione Torre</option>');
        $("#idtorre").append(r);

        // Inicializar Select2 nuevamente
        $('#idtorre').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione una Torre',
            allowClear: true,
        });
      });
}


var cont = 0;

function listar_torre(event) {
  event.preventDefault();

  var idtorre = $("#idtorre").val();
  var idtecnologia = $("#idtecnologia").val();

  // Validar que las fechas no estén vacías
  if (!idtorre || !idtecnologia) {
     Swal.fire({
            title: "Campos requeridos",
            text: "Por favor, seleccione la torre y la tecnologia.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
  }

  if (idtorre) {
    $.post(
      "../../ajax/reporte.php?op=listar_torre",
      { idtorre: idtorre, idtecnologia: idtecnologia },
      function (data, status) {
        if (status === "success") {
          const response = JSON.parse(data);
          if (response.cabeceras && response.cabeceras.length > 0) {
            if ($.fn.DataTable.isDataTable("#listar_torre")) {
              $("#listar_torre").DataTable().clear().destroy();
            }
            $("#listar_torre tbody").empty(); // Limpiar filas anteriores
            for (var i = 0; i < response.cabeceras.length; i++) {
              const cabecera = response.cabeceras[i];
          
              // Crear un contenedor para cabecera y detalles
              let grupo = "";
              // Fila principal del cliente (cabecera)
              let filaGrupo = '<tr class="filas" id="fila' + cont + '">' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC">' + cabecera.nombre_repetidor + '</td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '<td style="font-size:14px; text-align:center; background-color:#CCCCCC"></td>' +
                  '</tr>';
              grupo += filaGrupo;
              cont++;
              // Filtramos los detalles para este idcontrato
              const detallesCabecera = response.detalles[cabecera.idrepetidor];
              // Verificamos si hay detalles para este contrato
              if (detallesCabecera && detallesCabecera.length > 0) {
                  for (var j = 0; j < detallesCabecera.length; j++) {
                      const detalle = detallesCabecera[j];
                      const olt = detalle.nombreolt?.trim() ? detalle.nombreolt : "";
                      let filaDetalle = '<tr class="filas detalles" id="detalle' + cont + '">' +
                          '<td></td>' + // Dejar la celda vacía para mantener el diseño
                          '<td>'+ olt +'</td>' +
                          '<td>'+ detalle.cliente +'</td>' +
                          '<td>'+ detalle.modalidad +'</td>' +
                          '<td>'+ detalle.montomensualidad +'</td>' +
                          '<td>'+ detalle.sit_contrato +'</td>' +
                          '<td>'+ detalle.description +'</td>' +
                          '<td>'+ detalle.address +'</td>' +
                          '<td>'+ detalle.celular +'</td>' +
                          '<td>'+ detalle.telefono +'</td>' +
                          '<td>'+ detalle.whatsapp +'</td>' +
                          '</tr>';
                      grupo += filaDetalle;
                      cont++;
                  }
              }
              // Agregar todo el grupo (cabecera + detalles) de una sola vez
              $("#listar_torre tbody").append(grupo);
          }

          } else {
            Swal.fire({
            title: "Datos Vacios",
            text: "No se encontraron datos.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
          }
        } else {
          console.error("Error en la solicitud AJAX.");
        }
      }
    );
  }
}

async function generarExcel() {
    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet("Torre x Repetidoras");

    worksheet.columns = Array.from({ length: 11 }, () => ({
    width: 20
    }));

    // Obtener encabezados de la tabla
    const table = document.getElementById("listar_torre");
    const headers = Array.from(table.querySelectorAll("thead th")).map(th => th.innerText.trim());

    // Agregar los encabezados al Excel
    worksheet.addRow(headers);
    const headerRow = worksheet.getRow(1);
    headerRow.font = { bold: true };
    headerRow.alignment = { horizontal: 'center' };

    // Obtener todas las filas de la tabla
    const filas = table.querySelectorAll("tbody tr");

    filas.forEach((tr, index) => {
        const celdas = Array.from(tr.children).map(td => td.innerText.trim());
        const row = worksheet.addRow(celdas);

        // Aplicar estilos según si es cabecera (fondo gris claro)
        if (tr.classList.contains("detalles")) {
            // Estilo para detalles (normal)
            row.eachCell(cell => {
                cell.font = { color: { argb: 'FF000000' } };
                cell.border = {
                    top: { style: 'thin' },
                    left: { style: 'thin' },
                    bottom: { style: 'thin' },
                    right: { style: 'thin' },
                };
            });
        } else {
            // Estilo para cabeceras de repetidor (fondo gris)
            row.eachCell(cell => {
                cell.fill = {
                    type: 'pattern',
                    pattern: 'solid',
                    fgColor: { argb: 'FFCCCCCC' },
                };
                cell.font = { bold: true, color: { argb: 'FF000000' } };
                cell.alignment = { horizontal: 'center' };
                cell.border = {
                    top: { style: 'thin' },
                    left: { style: 'thin' },
                    bottom: { style: 'thin' },
                    right: { style: 'thin' },
                };
            });
        }
    });


    // Descargar el archivo
    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
    const link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "torres_repetidoras.xlsx";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}


init();