var tabla;
function init(){
    listar();
   // listarproductoM();
    evaluar();

    // Evento para enviar el formulario
    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    // Cargar el select de técnicos
    $.post("../../ajax/usuario.php?op=selectTecnico", function(r){
      if ($.fn.select2 && $('#idtecnico').data('select2')) {
        $('#idtecnico').select2('destroy');
      }

      $("#idtecnico").html('<option value="">Seleccione un Técnico</option>'); 
      // Actualizar el contenido del select con las opciones de producto
      $("#idtecnico").append(r);

      // Inicializar Select2 nuevamente
      $('#idtecnico').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un Técnico',
        allowClear: true,
      });

      // Capturar el cambio en el select de técnicos
      $('#idtecnico').on('change', function() {
        var idtecnico = $(this).val(); // Capturar el valor seleccionado
        console.log('ID Técnico seleccionado: ', idtecnico);
        // Llamar a listarproductoM con el idtecnico actualizado
        listarproductoM(idtecnico);
      });
    });
}

function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana RESTANDO el offset
  const peruTime = new Date(now.getTime() + (offset * 60 * 60 * 1000));

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Verificar si el elemento existe antes de asignarle un valor
  const inputFecha = document.getElementById('fecha_hora');
  if (inputFecha) {
    inputFecha.value = formattedDateTime;
  } else {
    //console.error("El elemento con id 'fecha_hora' no se encontró en el DOM.");
  }
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);


// Función para listar datos
function listar() {
    tabla=$("#productoretorno").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/retorno.php?op=listarretorno',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listarproductoM(idtecnico) {
    console.log('ID Técnico en listarproductoM: ', idtecnico); // Verificar si se pasa el valor correctamente
    tabla=$("#modalproducto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/retorno.php?op=listarproductoM',
            data:{idtecnico:idtecnico},
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e);
                alert("Error al cargar la tabla. Detalles: " + (e.responseText || "Sin detalles del servidor."));
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}



function mostrardetalleretorno(idretorno){   
    
    $.ajax({  
        url:"../../ajax/retorno.php?op=mostrardetalleretorno&id=" + idretorno,  
         method:"POST",  
         data:{idretorno:idretorno},  
         dataType:"json",  
         success:function(response){  
           console.log(response);                 
      
         var cont=0;                  
          var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
          html+="<thead>";
          html+="<tr '>";
          html+="<th style='background-color:#050505; color: white;'>Fecha Retorno</th>";
          html+="<th style='background-color:#050505; color: white;'>Tecnico</th>";
          html+="<th style='background-color:#050505; color: white;'>Cod Madre</th>";
          html+="<th style='background-color:#050505; color: white;'>Codigo</th>";
          html+="<th style='background-color:#050505; color: white;'>Estado Material</th>";
          html+="<th style='background-color:#050505; color: white;'>Producto</th>";                 
          html+="<th style='background-color:#050505; color: white;'>Cantidad</th>";
          html+="<th style='background-color:#050505; color: white;'>U.Medida</th>";
          html+="<th style='background-color:#050505; color: white;'>Precio Retorno</th>";
          html+="<th style='background-color:#050505; color: white;'>Movimiento</th> </tr></thead>";

          html+="<tbody>";              

          for (i = 0; i < response.detalles.length; i++) {  

          if(response.detalles[i].estadomovimiento =='3'){
            response.detalles[i].estadomovimiento='<button class="btn btn-danger btn-xs btn-flat">Retorno</button>';
          }

          if(response.detalles[i].estadomaterial =='1'){
            response.detalles[i].estadomaterial='<button class="btn btn-success btn-xs btn-flat">Nuevo</button>';
          }else if(response.detalles[i].estadomaterial =='2'){
            response.detalles[i].estadomaterial='<button class="btn btn-warning btn-xs btn-flat">Usado</button>';
          }else if(response.detalles[i].estadomaterial =='3'){
            response.detalles[i].estadomaterial='<button class="btn btn-primary btn-xs btn-flat">Reparado</button>';
          }else if(response.detalles[i].estadomaterial =='4'){
            response.detalles[i].estadomaterial='<button class="btn btn-danger btn-xs btn-flat">Malogrado</button>';
          }

             html += '<tr>' +
            //'<tr>'+
            '<td>' + response.detalles[i].fecharetorno + '</td>' +
            '<td>' + response.detalles[i].tecnico + '</td>' +
            '<td>' + response.detalles[i].madre + '</td>' +
            '<td>' + response.detalles[i].codigo + '</td>' +
            '<td>' + response.detalles[i].estadomaterial + '</td>' +
            '<td>' + response.detalles[i].producto + '</td>' +                                       
            '<td>' + response.detalles[i].cantidad + '</td>' +
            '<td>' + response.detalles[i].unidadmedida + '</td>' +
            '<td>' + response.detalles[i].precio_venta + '</td>' +
            '<td>' + response.detalles[i].estadomovimiento + '</td>' +               
            '</tr>' ;
            }
         
            html+="</tbody>";
            html+="</table>";                 
            document.getElementById("tblarticulosRetorno").innerHTML=html;              
                        
         },
         error: function(xhr, status, error) {
            console.error("Error en la petición:", error);
            console.error(xhr.responseText);
          } 

    });  
}

let detalles = 0;
let cont = 0;

function agregarDetalle( idarticulo, articulo, marca, mac, precio_compra, codigo, estadomaterial, precio_venta, stock, idaveria, estado, cantidadusado,cantidaddevuelto,cantidadsalida,idalmacen, idmovimiento_materiales, filaBoton) {
    let cantidad = 1;

    // Validar que el código no esté repetido
    if (codigoYaExiste(codigo)) {
      Swal.fire({
          icon: 'error',
          title: 'Artículo duplicado',
          text: `El artículo con código ${codigo} ya está agregado.`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      return; // Salir de la función para evitar agregar el artículo duplicado
  }

    if (idarticulo !== "") {
        const fila = `
        <tr class="filas" id="fila${cont}">
            <td>
                <button type="button" class="btn btn-danger" onclick="eliminarDetalle(${cont})">X</button>
            </td>
            <td>
                <select class="form-control" name="estadomaterial[]" id="estadomaterial[]">
                    <option value="1">Nuevo</option>
                    <option value="2">Usado</option>
                    <option value="3">Reparado</option>
                    <option value="4">Malogrado</option>
                </select>
            </td>
            <td>
                <input type="hidden" name="idarticulo[]" value="${idarticulo}">
                <input type="hidden" name="idaveria[]" value="${idaveria}">
                <input type="hidden" name="estado[]" value="${estado}">
                <input type="hidden" name="cantidadusado[]" value="${cantidadusado}">
                <input type="hidden" name="cantidaddevuelto[]" value="${cantidaddevuelto}">
                <input type="hidden" name="cantidadsalida[]" value="${cantidadsalida}">
                <input type="hidden" name="idalmacen[]" value="${idalmacen}">
                <input type="hidden" name="idmovimiento_materiales[]" value="${idmovimiento_materiales}">
                ${articulo}
            </td>
            <td><input readonly class="form-control" type="text" name="codigo[]" value="${codigo}"></td>
            <td><input readonly class="form-control" type="text" name="marca[]" value="${marca}"></td>
            <td><input readonly class="form-control" type="text" name="mac[]" value="${mac}"></td>
            <td>
                <input type="number" class="form-control" name="cantidad[]" id="cantidad${cont}" value="${cantidad}" min="1" max="${cantidadsalida}" data-stock="${cantidadsalida}">
                <input type="hidden" name="precio_compra[]" value="${precio_compra}">
            </td>
            <td>
                <input type="number" class="form-control" step="0.01" name="precio_venta[]" id="precio_venta${cont}" min="0.00" value="${precio_venta}">
            </td>
        </tr>
    `;

        detalles++;
        $('#detalles').append(fila);

        // Registrar eventos

        $(`#cantidad${cont}`).on('keyup change', function () {
          validarStock(this);
          modificarSubtotales();
          });

        $(`#cantidad${cont}, #precio_venta${cont}`).on('keyup change', modificarSubtotales);

        cont++;
        modificarSubtotales();
        evaluar();
        $(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
    } else {
        alert("Error al ingresar el detalle, revisar los datos del artículo");
    }
}

// Función para validar si el código ya existe
function codigoYaExiste(codigo) {
  let existe = false;
  $("input[name='codigo[]']").each(function () {
      if ($(this).val() === codigo) {
          existe = true;
      }
  });
  return existe;
}

function validarStock(elemento) {
    const stock = parseFloat($(elemento).data('stock'));
    const cantidad = parseFloat($(elemento).val());

    if (cantidad > stock) {
          Swal.fire({
            icon: 'error',
            title: 'Cantidad excedida',
            text: `La cantidad no puede exceder el stock disponible (${stock}).`,
            confirmButtonText: 'Aceptar',
            timer: 3000
        });
        $(elemento).val(stock); // Ajustar al valor máximo permitido
    }
}

function modificarSubtotales() {
    const cantidades = document.getElementsByName("cantidad[]");
    const precios = document.getElementsByName("precio_venta[]");

    for (let i = 0; i < cantidades.length; i++) {
        const cantidad = parseFloat(cantidades[i].value) || 0;
        const precio = parseFloat(precios[i].value) || 0;
    }
    
}
function evaluar() {
    if (detalles > 0) {
        $("#btnGuardar").show();
    } else {
        $("#btnGuardar").hide();
        cont = 0;
    }
}

function eliminarDetalle(indice) {
    $(`#fila${indice}`).remove();
    detalles--;
    evaluar();
   
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});
// Función para guardar o editar
function guardaryeditar(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#frmForm")[0]);
  
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Si el usuario confirma, realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/retorno.php?op=guardaryeditar",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Mostrar mensaje de éxito o error según la respuesta del backend
            swalWithBootstrapButtons.fire({
              title: 'Resultado',
              text: datos, // Mostrar el mensaje devuelto por el backend
              icon: datos.includes("Retorno Registrado") || datos.includes("Retorno Actualizada") ? 'success' : 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              if (datos.includes("Retorno Registrado") || datos.includes("Retorno Actualizada")) {
                // Redirigir al listado si la operación fue exitosa
                window.location.href = "list.php";
                limpiar();
              } else {
                // Si hubo un error, redirigir al formulario de creación
                window.location.href = "create.php";
              }
            });
          },
          error: function (err) {
            // Manejar errores en la solicitud AJAX
            swalWithBootstrapButtons.fire({
              title: 'Error',
              text: 'Hubo un problema con la solicitud. Intente nuevamente.',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    }).finally(() => {
      $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
    });
    
  }



init();