var tabla;
function init(){
    evaluar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditarAntiguo(e);
    });

    $.post("../../ajax/usuario.php?op=selectTecnico", function(r){
      if ($.fn.select2 && $('#idtecnico').data('select2')) {
        $('#idtecnico').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idtecnico").html('<option value="">Seleccione un Técnico</option>'); 
      // Actualizar el contenido del select con las opciones de producto
      $("#idtecnico").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idtecnico').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un Tecnico',
        allowClear: true,
      });
    });

   
}

function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana
  const peruTime = new Date(now.getTime() + offset * 60 * 60 * 1000);

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Asignar al campo
  document.getElementById('fecha_hora').value = formattedDateTime;
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);

function listarArticulos() {
    tabla=$("#modalproducto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/retorno.php?op=listarArticulos',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

$('#myModalIngreso').on('shown.bs.modal', function () {
  listarArticulos();

});




let detalles = 0;
let cont = 0;

function agregarDetalle(idarticulo, codigo, articulo, nroproducto, filaBoton) {
    let cantidad = 1;

    // Validar que el código no esté repetido
    if (codigoYaExiste(codigo)) {
      Swal.fire({
          icon: 'error',
          title: 'Artículo duplicado',
          text: `El artículo con código ${codigo} ya está agregado.`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      return; // Salir de la función para evitar agregar el artículo duplicado
  }

    if (idarticulo !== "") {
        const fila = `
        <tr class="filas" id="fila${cont}">
            <td>
                <button type="button" class="btn btn-danger" onclick="eliminarDetalle(${cont})">X</button>
            </td>
            <td>
                <select class="form-control" name="estadomaterial[]" id="estadomaterial[]">
                    <option value="1">Nuevo</option>
                    <option value="2">Usado</option>
                    <option value="3">Reparado</option>
                    <option value="4">Malogrado</option>
                </select>
            </td>
            <td>
                <input type="hidden" name="idarticulo[]" value="${idarticulo}">                
                ${articulo}
            </td>
            <td><input  class="form-control" type="text" name="codigo[]" value=""></td>
            <td><input  class="form-control" type="text" name="marca[]" value=""></td>
            <td><input  class="form-control" type="text" name="mac[]" value=""></td>
            <td><input  class="form-control" type="text" name="serie[]" value=""></td>
            <td>
                <input type="number" class="form-control" name="cantidad[]" id="cantidad${cont}" value="${cantidad}" min="1" >
                <input type="hidden" name="nrofactura[]" value="S/N">
                <input type="hidden" name="idprovedor[]" value="1">
                <input type="hidden" name="garantia[]" value="0">
            </td>
            <td>
                <input type="number" class="form-control" step="0.01" name="precio_venta[]" id="precio_venta${cont}" min="1" value="0">
            </td>
        </tr>
    `;

        detalles++;
        $('#detalles').append(fila);

        // Registrar eventos
        $(`#cantidad${cont}, #precio_venta${cont}`).on('keyup change', modificarSubtotales);

        cont++;
        modificarSubtotales();
        evaluar();
        //$(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
    } else {
        alert("Error al ingresar el detalle, revisar los datos del artículo");
    }
}

// Función para validar si el código ya existe
function codigoYaExiste(codigo) {
  let existe = false;
  $("input[name='codigo[]']").each(function () {
      if ($(this).val() === codigo) {
          existe = true;
      }
  });
  return existe;
}



function modificarSubtotales() {
    const cantidades = document.getElementsByName("cantidad[]");
    const precios = document.getElementsByName("precio_venta[]");

    for (let i = 0; i < cantidades.length; i++) {
        const cantidad = parseFloat(cantidades[i].value) || 0;
        const precio = parseFloat(precios[i].value) || 0;
    }
    
}
function evaluar() {
    if (detalles > 0) {
        $("#btnGuardar").show();
    } else {
        $("#btnGuardar").hide();
        cont = 0;
    }
}

function eliminarDetalle(indice) {
    $(`#fila${indice}`).remove();
    detalles--;
    evaluar();
   
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});
// Función para guardar o editar
function guardaryeditarAntiguo(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#frmForm")[0]);
  
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Si el usuario confirma, realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/retorno.php?op=guardaryeditarAntiguo",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Mostrar mensaje de éxito o error según la respuesta del backend
            swalWithBootstrapButtons.fire({
              title: 'Resultado',
              text: datos, // Mostrar el mensaje devuelto por el backend
              icon: datos.includes("Retorno Registrado") || datos.includes("Retorno Actualizada") ? 'success' : 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              if (datos.includes("Retorno Registrado") || datos.includes("Retorno Actualizada")) {
                // Redirigir al listado si la operación fue exitosa
                window.location.href = "list.php";
                limpiar();
              } else {
                // Si hubo un error, redirigir al formulario de creación
                window.location.href = "create.php";
              }
            });
          },
          error: function (err) {
            // Manejar errores en la solicitud AJAX
            swalWithBootstrapButtons.fire({
              title: 'Error',
              text: 'Hubo un problema con la solicitud. Intente nuevamente.',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    }).finally(() => {
      $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
    });
    
  }



init();