var tabla;
let map, marker, geocoder;
let cajaMarkers = [];
var cont = 0;


// 📌 Función principal para inicializar el mapa
function initMap() {
    geocoder = new google.maps.Geocoder();

    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            (position) => {
                console.log("Ubicación obtenida:", position.coords.latitude, position.coords.longitude);
                mostrarMapa(position.coords.latitude, position.coords.longitude);
                obtenerCajas(); // Llamar a obtenerCajas después de cargar el mapa
            },
            (error) => {
                if (error.code === error.PERMISSION_DENIED) {
                    Swal.fire({
                        icon: "warning",
                        title: "Acceso denegado",
                        text: "Has bloqueado la geolocalización. Actívala en la configuración del navegador o introduce una dirección manualmente.",
                        confirmButtonText: "Aceptar"
                    });
                } else {
                    alert("No se pudo obtener la ubicación. Seleccione manualmente.");
                }
                mostrarMapa(-12.0464, -77.0428); // Lima por defecto
                obtenerCajas(); // Llamar a obtenerCajas después de cargar el mapa
            }
        );
    } else {
        alert("Geolocalización no soportada");
        mostrarMapa(-12.0464, -77.0428);
        obtenerCajas(); // Llamar a obtenerCajas después de cargar el mapa
    }

            $.post("../../ajax/olt.php?op=selectOlt", function(r) {
                const $select = $('#idolt');

                // Destruir Select2 si ya está inicializado
                if ($select.hasClass("select-hidden-accessible")) {
                    $select.select('destroy');
                }

                // Limpiar y agregar opciones
                $select.html('<option value="">Seleccione Olt</option>' + r);

                // Inicializar Select2
                $select.select({
                    theme: 'bootstrap4', // solo si usas Bootstrap 4
                    placeholder: 'Seleccione una OLT',
                    allowClear: true
                });
            });

            $.post("../../ajax/icono.php?op=selectIcono", function(r) {
                const $select = $('#idicono');

                // Destruir Select2 si ya está inicializado
                if ($select.hasClass("select-hidden-accessible")) {
                    $select.select('destroy');
                }

                // Limpiar y agregar opciones
                $select.html('<option value="">Seleccione Icono</option>' + r);

                // Inicializar Select2
                $select.select({
                    theme: 'bootstrap4', // solo si usas Bootstrap 4
                    placeholder: 'Seleccione una OLT',
                    allowClear: true
                });
            });
   
}

function obtenerCajas() {
    fetch("obtener_cajas.php")
        .then(response => response.json())
        .then(cajas => {
            if (!map) {
                console.error("Mapa no inicializado");
                return;
            }

            cajas.forEach(caja => {
                const iconUrl = caja.imagen
                ? `https://new.inntelperu.com/template/files/icono/${caja.imagen}`
                : "https://new.inntelperu.com/template/files/no_disponible.jpg";
                let marker = new google.maps.Marker({
                    position: { lat: parseFloat(caja.latitud), lng: parseFloat(caja.longitud) },
                    map,
                    title: caja.nombre,
                    icon: {
                        url: iconUrl,
                        scaledSize: new google.maps.Size(40, 40) // Tamaño del icono
                    }
                });

                let infoWindow = new google.maps.InfoWindow({
                    content: `<strong>${caja.nombre}</strong>`
                });

                marker.addListener("click", () => {
                    infoWindow.open(map, marker);
                    cargarLineas(caja.idcaja,caja.nombre);
                });
                cajaMarkers.push(marker);
            });
        })
        .catch(error => console.error("Error al obtener cajas:", error));
}

function cargarLineas(idcaja,nombre) {

    console.log(idcaja);
    $("strong#nombre_caja").text(nombre);
    $.post("../../ajax/ubicacion.php?op=cargar_linea",
        {idcaja: idcaja},
        function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.cajas && response.cajas.length > 0) {
                for (var i = 0; i < response.cajas.length; i++) {
                    const caja = response.cajas[i];
                    // Obtener el nombre de la imagen
                   
                    $("#idcaja").val(caja.idcaja);
                    $("#idcaja_informacion").val(caja.idcaja);
                    $("#latitud").val(caja.latitud);
                    $("#longitud").val(caja.longitud);
                    $("#direccion_capturada").val(caja.address);
                    $("#zona").val(caja.zona);
                    $("#nombre_prime").val(caja.nombre);
                    $("#nombre").val(caja.nombre);
                    $("#capacidad").val(caja.capacidad);
                    $("#tarjeta").val(caja.tarjeta);
                    $("#puerto").val(caja.puerto);
                    $("#autorizacion").val(caja.autorizacion).trigger('change');
                    $("#idicono").val(caja.idicono).trigger('change');
                    $("#descripcion").val(caja.descripcion);
                    setTimeout(function () {
                    $("#idolt").val(caja.idolt).trigger('change');
                    }, 300);

                    const nombreImagen = caja.imagen_caja;
                    const rutaImagen = nombreImagen && nombreImagen.trim() !== ""
                        ? `../../files/caja/${nombreImagen}`
                        : `../../files/no_disponible.jpg`;
                    // Asignar la imagen al <img>
                    $('#previewImagenPoste').attr('src', rutaImagen);
                    // Guardar el nombre en un input oculto
                    $('#previewImagenPosteHidden').val(nombreImagen);
                }
            }

            if (response.detalles && response.detalles.length > 0) {
                  $("#punto tbody").empty(); // Limpiar filas anteriores

                  for (var i = 0; i < response.detalles.length; i++) {
                        const detalle = response.detalles[i];
                        let grupo = "";

                        // Función para validar y mostrar "-"
                        const mostrarValor = (valor) => {
                            return (valor === null || valor === "" || typeof valor === "undefined") ? "-" : valor;
                        };

                        let filaGrupo = '<tr class="filas" id="fila' + cont + '">' +
                            '<td>' + (i + 1) + '</td>' +
                            '<td>' + mostrarValor(detalle.nrocontrato) + '</td>' +
                            '<td>' + mostrarValor(detalle.num_documento) + '</td>' +
                            '<td>' + mostrarValor(detalle.sit_contrato) + '</td>' +
                            '<td><button class="btn btn-warning btn-xs btn-flat" onclick="mostrar_contrato(' + detalle.iddetalle_caja + ', ' + detalle.idcaja + ', \'' + detalle.nombre + '\')" data-toggle="modal" data-target="#modalContrato"><i class="fa fa-edit"></i></button></td>' +
                            '</tr>';

                        grupo += filaGrupo;
                        cont++;
                        $("#punto").append(grupo);
                    }

            } else {
               $("#punto tbody").empty();
              }
            } else {
              console.error("Error en la solicitud AJAX.");
            }
          }
        );
}

function mostrar_contrato(iddetelle,idcaja,nombre) {
  // Asigna el valor de idaveria al input oculto en el modal
  cerrarYRefrescar();
  $('#detalle_id').val(iddetelle);
  $('#idcaja_cliente').val(idcaja);
  $('#nombre_caja_cliente').val(nombre);
 
}


// 📌 Función para mostrar y configurar el mapa
function mostrarMapa(lat, lng) {
    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat, lng },
        zoom: 15
    });

    marker = new google.maps.Marker({
        position: { lat, lng },
        map,
        draggable: true,
        title: "Mueve para seleccionar un punto"
    });

    // 📌 Evento cuando se mueve el marcador
    marker.addListener('dragend', function () {
        let position = marker.getPosition();
        actualizarCoordenadas(position.lat(), position.lng());
    });
}

// 📌 Función para buscar ubicación con geocoder
function buscarUbicacion() {
    let address = document.getElementById("search_location").value.trim();
    if (!address) {
        alert("Por favor, ingresa una dirección.");
        return;
    }

    if (!geocoder) {
        alert("El mapa no se ha inicializado correctamente.");
        return;
    }

    geocoder.geocode({ 'address': address }, function (results, status) {
        if (status === google.maps.GeocoderStatus.OK) {
            let location = results[0].geometry.location;
            map.setCenter(location);
            marker.setPosition(location);
            actualizarCoordenadas(location.lat(), location.lng());
        } else {
            alert("No se encontró la ubicación: " + status);
        }
    });
}

// 📌 Función para actualizar las coordenadas en la interfaz
function actualizarCoordenadas(lat, lng) {
    document.getElementById("latitudd").textContent = lat;
    document.getElementById("longitudd").textContent = lng;
    console.log(`Coordenadas actualizadas: ${lat}, ${lng}`);
}

// 📌 Función para guardar datos
function guardarCaja(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true);

    let direccion_capturada = $("#direccion_capturada").val();
    let latitud = $("#latitud").val();
    let longitud = $("#longitud").val();
    let idicono = $("#idicono").val();
    let nombree= $("#nombre_prime").val();

    if (!nombree || !direccion_capturada || !latitud || !longitud || !idicono) {
        Swal.fire("Error", "Ingresa los datos requeridos.", "error");
        $("#btnGuardar").prop("disabled", false);
        return;
    }
    var formData = new FormData($("#formImganen")[0]);
    
    Swal.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas guardar los cambios realizados?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, guardar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "../../ajax/ubicacion.php?op=guardaryeditar",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);
                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Guardando...",
                                html: "Por favor, espera mientras se procesan los datos.",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                didOpen: () => Swal.showLoading(),
                                willClose: () => $(location).attr("href", "create.php")
                            });
                        } else {
                            Swal.fire("Error", datos.message, "error");
                            $("#btnGuardar").prop("disabled", false);
                        }
                    } catch (error) {
                        Swal.fire("Error", "Hubo un problema con la respuesta del servidor.", "error");
                        $("#btnGuardar").prop("disabled", false);
                    }
                },
                error: function () {
                    Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
                    $("#btnGuardar").prop("disabled", false);
                }
            });
        } else {
            Swal.fire("Cancelado", "No se realizaron cambios.", "error");
            $("#btnGuardar").prop("disabled", false);
        }
    });
}

// 📌 Función para guardar datos
function guardarInformacion(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnInformacion").prop("disabled", true);

    let zona = $("#zona").val();
    let nombre = $("#nombre").val();
    let capacidad = $("#capacidad").val();
    let olt = $("#idolt").val();
    let autorizacion = $("#autorizacion").val();

    if (!zona || !nombre || !capacidad || !olt || !autorizacion) {
        Swal.fire("Error", "Ingresa los datos requeridos", "error");
        $("#btnInformacion").prop("disabled", false);
        return;
    }
    var formData = new FormData($("#formInformacion")[0]);
    
    Swal.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas guardar los cambios realizados?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, guardar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "../../ajax/ubicacion.php?op=guardaryeditar_informacion",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);
                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Guardando...",
                                html: "Por favor, espera mientras se procesan los datos.",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                didOpen: () => Swal.showLoading(),
                                willClose: () => $(location).attr("href", "create.php")
                            });
                        } else {
                            Swal.fire("Error", datos.message, "error");
                            $("#btnInformacion").prop("disabled", false);
                        }
                    } catch (error) {
                        Swal.fire("Error", "Hubo un problema con la respuesta del servidor.", "error");
                        $("#btnInformacion").prop("disabled", false);
                    }
                },
                error: function () {
                    Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
                    $("#btnInformacion").prop("disabled", false);
                }
            });
        } else {
            Swal.fire("Cancelado", "No se realizaron cambios.", "error");
            $("#btnInformacion").prop("disabled", false);
        }
    });
}

// 📌 Cargar el mapa cuando la ventana esté lista
google.maps.event.addDomListener(window, 'load', initMap);


function capturarUbicacion() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(
      (position) => {
        const latt = position.coords.latitude;
        const lonn = position.coords.longitude;

        document.getElementById('latitud').value = latt;
        document.getElementById('longitud').value = lonn;

        obtenerDireccion(latt, lonn);
      },
      (error) => {
        Swal.fire("Error", "No se pudo obtener la ubicación.", "error");
      }
    );
  } else {
    Swal.fire("Error", "Tu navegador no soporta geolocalización.", "error");
  }
}

function obtenerDireccion(latt, lonn) {
  const apiKey = 'AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA'; // <-- Reemplaza con tu API Key válida
  const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${latt},${lonn}&key=${apiKey}`;

  fetch(url)
    .then(response => response.json())
    .then(data => {
      if (data.status === "OK") {
        const address = data.results[1].formatted_address;
        document.getElementById('direccion_capturada').value = address;
      } else {
        document.getElementById('direccion_capturada').value = "Dirección no encontrada";
      }
    })
    .catch(() => {
      document.getElementById('direccion_capturada').value = "Error al obtener dirección";
    });
}




 const inputImagen = document.getElementById('inputImagenPoste');
  const preview = document.getElementById('previewImagenPoste');

  preview.addEventListener('click', () => {
    inputImagen.click();
  });

  inputImagen.addEventListener('change', () => {
    const file = inputImagen.files[0];
    if (file) {
      const reader = new FileReader();
      reader.onload = function (e) {
        preview.src = e.target.result;
      };
      reader.readAsDataURL(file);
    }
  });


function consultarCliente() {
    const dni = document.getElementById('inputDNI').value.trim();
    const resultado = document.getElementById('resultadoDNI');

    if (dni === "") {
        resultado.innerHTML = `<i class="fa fa-exclamation-circle text-warning"></i> Por favor, ingrese un DNI o RUC.`;
        return;
    }
    // Validación básica de DNI (8) o RUC (11)
    if (!/^\d+$/.test(dni)) {
        resultado.innerHTML = `<i class="fa fa-exclamation-circle text-warning"></i> Ingrese solo números válidos para el DNI o RUC.`;
        return;
    }
    resultado.innerHTML = "Consultando...";
    $.ajax({
        url: '../../ajax/cliente.php?op=consultarDNI',
        type: 'POST',
        dataType: 'json',
        data: { dni: dni },
        success: function(response) {
            $("#idcontrato").val(response.idcontrato);
            if (response.existe) {
                resultado.innerHTML = `<i class="fa fa-check-circle text-success"></i> DNI/RUC ${dni} está registrado como <strong>${response.nombre}</strong> con Nro-Contrato <strong>${response.nrocontrato}</strong>.`;
            } else {
                resultado.innerHTML = `<i class="fa fa-times-circle text-danger"></i> DNI/RUC ${dni} no está registrado en la base de datos.`;
            }
        },
        error: function() {
            resultado.innerHTML = `<i class="fa fa-exclamation-circle text-danger"></i> Error en la consulta. Inténtalo de nuevo.`;
        }
    });
}

function registrarCliente() {
    const dni = document.getElementById('inputDNI').value.trim();
    const idcontrato = document.getElementById('idcontrato').value;
    const detalle_id = document.getElementById('detalle_id').value;
    const idcaja_cliente = document.getElementById('idcaja_cliente').value;
    const nombre_caja = document.getElementById('nombre_caja_cliente').value;

    if (dni === "" || idcontrato === "") {
        Swal.fire({
            icon: 'warning',
            title: 'Atención',
            text: 'Primero consulte un DNI/RUC válido antes de registrar.',
            timer: 2000,
            showConfirmButton: false
        });
        return;
    }

    $.ajax({
        url: '../../ajax/ubicacion.php?op=registrarDatos',
        type: 'POST',
        dataType: 'json', // <- importante para parsear JSON automáticamente
        data: { dni: dni, idcontrato: idcontrato, detalle_id: detalle_id },
        success: function(response) {
            if (response.status === "success") {
               // $('#modalContrato').modal('hide');

                Swal.fire({
                    icon: 'success',
                    title: 'Registrado',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });

                setTimeout(() => {
                    cargarLineas(idcaja_cliente,nombre_caja);
                }, 2000);
                cerrarYRefrescar();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message || 'No se pudo registrar el cliente.',
                    timer: 2000,
                    showConfirmButton: false
                });
            }
        },
        error: function() {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudo registrar el cliente.',
                timer: 2000,
                showConfirmButton: false
            });
        }
    });
}


function cerrarYRefrescar() {
    // Limpiar formulario
    $('#formInsert')[0].reset();
    $('#detalle_id').val('');
    $('#idcaja_cliente').val('');
    $('#nombre_caja_cliente').val('');
    $('#nombre_caja').text('');
    $('#resultadoDNI').text('');

}