var tabla;
function init(){
          listar();
          listarpermiso();
          $("#frmForm").on("submit", function (e) {
            guardaryeditar(e);
        });

        $("#imagenmuestra").hide();

        // Mostramos los permisos
        $.post("../../ajax/usuario.php?op=permisos&id=", function (r) {
            $("#permisos").html(r);
        });

        // Cargar tipos de documento y validar al cargar
        // Cargar tipos de documento y validar al cargar
        $.post("../../ajax/cliente.php?op=selectTipoDocumento", function (r) {
          if ($.fn.select2 && $('#idtipo_documento').data('select2')) {
              $('#idtipo_documento').select2('destroy');
          }

          // Actualizar el contenido del select
          $("#idtipo_documento").html(r);

          // Inicializar Select2 nuevamente
          $('#idtipo_documento').select2({
              theme: 'bootstrap4',
              placeholder: 'Seleccione Tipo Documento',
              allowClear: true,
          });

          // Ejecuta la validación inicial después de cargar el select
          validarTipoDocumento();
      });

        // Cargar cargos
        $.post("../../ajax/usuario.php?op=selectCargo", function (r) {
            if ($.fn.select2 && $('#cargo').data('select2')) {
                $('#cargo').select2('destroy');
            }

            // Actualizar el contenido del select
            $("#cargo").html(r);

            // Inicializar Select2 nuevamente
            $('#cargo').select2({
                theme: 'bootstrap4',
                placeholder: 'Seleccione Cargo',
                allowClear: true,
            });
        });

        // Función para validar el tipo de documento y configurar restricciones
        function validarTipoDocumento() {
          const tipoDocumento = $('#idtipo_documento').val(); // Obtiene el ID del tipo de documento seleccionado
          const numDocumentoInput = $('#num_documento');
          const numDocumentoHelp = $('#num_documento_help');

          numDocumentoInput.val(''); // Reinicia el campo de número de documento
          numDocumentoHelp.text(''); // Limpia el texto de ayuda

          // Aplica validaciones según el tipo de documento
          if (tipoDocumento === '1') { // Asume que '1' es DNI
              numDocumentoInput.attr('data-maxlength', 8); // Valor personalizado para validación
              numDocumentoHelp.text('El número de documento debe tener exactamente 8 dígitos (DNI).');
          } else if (tipoDocumento === '2') { // Asume que '2' es RUC
              numDocumentoInput.attr('data-maxlength', 11); // Valor personalizado para validación
              numDocumentoHelp.text('El número de documento debe tener exactamente 11 dígitos (RUC).');
          } else {
              numDocumentoInput.removeAttr('data-maxlength'); // Quita cualquier restricción si no aplica
              numDocumentoHelp.text('Seleccione un tipo de documento válido.');
          }
      }

      // Evento change para actualizar la validación cuando se cambia el tipo de documento
      $('#idtipo_documento').on('change', validarTipoDocumento);

      // Validación en tiempo real para restringir la longitud del número
      $('#num_documento').on('input', function () {
          const maxLength = $(this).attr('data-maxlength'); // Obtiene el valor máximo permitido
          const value = $(this).val();

          if (maxLength && value.length > maxLength) {
              $(this).val(value.slice(0, maxLength)); // Trunca el valor a la longitud máxima
          }
      });
        
}
//Función limpiar
function limpiar()
{
    $("#idusuario").val("");
    $("#nombre").val("");
    $("#idtipo_documento").val("");
    $("#num_documento").val("");
  	$("#direccion").val("");
    $("#telefono").val("");
    $("#email").val("");
    $("#login").val("");
    $("#clave").val("");
    $("#imagenmuestra").hide();
	  $("#imagenactual").val("");
	  $("#imagen").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/usuario.php?op=listarusuario',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listarpermiso() {
  tabla=$("#productopermiso").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/usuario.php?op=listarpermiso',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/usuario.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Usuario Registrado") || datos.includes("Usuario Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Usuario Registrado") || datos.includes("Usuario Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idusuario) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/usuario.php?op=eliminar", { idusuario: idusuario }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El usuario ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El usuario está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idusuario de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idusuario = urlParams.get('idusuario');

  if (idusuario) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/usuario.php?op=mostrar", { idusuario: idusuario }, function (data, status) {
          if (status === "success") {
              const usuario = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idusuario").val(usuario.idusuario);
              $("#nombre").val(usuario.nombre);
              $("#idtipo_documento").val(usuario.idtipo_documento).trigger('change'); // Actualiza Select2
              $("#num_documento").val(usuario.num_documento);
              $("#direccion").val(usuario.direccion);
              $("#telefono").val(usuario.telefono);
              $("#email").val(usuario.email);
              $("#login").val(usuario.login);
              $("#condicion").val(usuario.condicion);
              $("#imagenmuestra").show();
		          $("#imagenmuestra").attr("src","../../files/usuarios/"+usuario.imagen);
		          $("#imagenactual").val(usuario.imagen);
              $("#cargo").val(usuario.cargo).trigger('change');
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Registro')

          } else {
              console.error("Error al cargar los datos");
          }
      });
      $.post("../../ajax/usuario.php?op=permisos&id="+idusuario,function(r){
        $("#permisos").html(r);
      });
  }
});



init();