var tabla;
function init(){
    listar();
    listar_usuario();
    listarproducto();
    listarbuscar();
    evaluar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/cliente.php?op=selectCliente", function(r){
        if ($.fn.select2 && $('#idpersona').data('select2')) {
          $('#idpersona').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idpersona").html('<option value="">Seleccione Cliente</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idpersona").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idpersona').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un cliente',
          allowClear: true,
        });
      });

      $.post("../../ajax/banco.php?op=selectbanco", function(r){
        if ($.fn.select2 && $('#idbanco').data('select2')) {
          $('#idbanco').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idbanco").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idbanco').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un banco',
          allowClear: true,
        });
      });
    
}



document.addEventListener("DOMContentLoaded", function () {
  const tipoPagoElement = document.getElementById("tipopago");

  if (tipoPagoElement) {
    tipoPagoElement.addEventListener("change", function () {
      const tipoPago = this.value;

      if (tipoPago === "2") { // Depósito
        document.getElementById("deposito-fields").style.display = "none";
      } else if (tipoPago === "3") { // Efectivo
        document.getElementById("deposito-fields").style.display = "block";
      } else {
        document.getElementById("deposito-fields").style.display = "none";
      }
    });
  }
});

function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana RESTANDO el offset
  const peruTime = new Date(now.getTime() + (offset * 60 * 60 * 1000));

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Verificar si el elemento existe antes de asignarle un valor
  const inputFecha = document.getElementById('fecha_hora');
  if (inputFecha) {
    inputFecha.value = formattedDateTime;
  } else {
    //console.error("El elemento con id 'fecha_hora' no se encontró en el DOM.");
  }
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);
//Función limpiar
function limpiar()
{
	$("#idventa").val("");
  $("#fecha_hora").val("");
	$("#nroguia").val("");
  $("#nrocorrelativo").val(""); 
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/venta.php?op=listar',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listar_usuario() {
  tabla=$("#producto_usuario").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/venta.php?op=listar_usuario',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}

function listarproducto() {

  tabla=$("#modalproducto").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/venta.php?op=listarproducto',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}

function listarbuscar() {

  tabla=$("#modalbuscar").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/venta.php?op=listarbuscar',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}
// Configuración de SweetAlert2 con botones personalizados



let detalles = 0;
let cont = 0;

function agregarDetalle(idarticulo , articulo, marca, mac, serie, precio_compra, codigo, precio_venta, idinventario_ingreso, idalmacen ,stock, filaBoton) {
    let cantidad = 1;
     
    // Validar que el código no esté repetido
    if (codigoYaExiste(codigo)) {
      Swal.fire({
          icon: 'error',
          title: 'Artículo duplicado',
          text: `El artículo con código ${codigo} ya está agregado.`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      return; // Salir de la función para evitar agregar el artículo duplicado
  }

    if (idarticulo !== "") {
        const subtotal = cantidad * precio_venta;
        const fila = `
            <tr class="filas" id="fila${cont}">
                <td><button type="button" class="btn btn-danger btn-xs btn-flat" onclick="eliminarDetalle(${cont})"><i class="fa fa-trash"></i></button></td>
                <td>
                    <input  type="hidden" name="idarticulo[]" value="${idarticulo}">
                    <input type="hidden" name="idinventario_ingreso[]" value="${idinventario_ingreso}">
                    ${articulo}
                </td>
                <td><input readonly class="form-control" type="text" name="codigo[]" value="${codigo}"></td>
                <td><input readonly class="form-control" type="text" name="marca[]" value="${marca}"></td>
                <td><input readonly class="form-control" type="text" name="mac[]" value="${mac}"></td>
                <td>
                    <input type="number" class="form-control" name="cantidad[]" id="cantidad${cont}" value="${cantidad}" min="1" max="${stock}" data-stock="${stock}">
                </td>
                <td><input readonly type="number" class="form-control" step="0.01" name="precio_compra[]" id="precio_compra[]${cont}" value="${precio_compra.toFixed(2)}"></td>
                <td><input type="number" class="form-control" step="0.01" name="precio_venta[]" id="precio_venta${cont}" min="${precio_compra}" value="${precio_venta.toFixed(2)}"></td>
                <td><span name="subtotal" id="subtotal${cont}">${subtotal.toFixed(2)}</span></td>
            </tr>
        `;

        detalles++;
        $('#detalles').append(fila);

        // Registrar eventos

        $(`#cantidad${cont}`).on('keyup change', function () {
          validarStock(this);
          modificarSubtotales();
          });

          $(`#precio_venta${cont}`).on('change keyup', function () {
            const precioVenta = parseFloat($(this).val()) || 0;
            if (precioVenta < precio_compra) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Precio inválido',
                    text: `El precio de venta no puede ser menor a S/. ${precio_compra.toFixed(2)}`,
                    confirmButtonText: 'Aceptar',
                    timer: 3000
                });
                $(this).val(precio_compra.toFixed(2)); // Restaurar el precio mínimo
            }
            modificarSubtotales();
        });

        $(`#cantidad${cont}, #precio_venta${cont}`).on('keyup change', modificarSubtotales);


        cont++;
        modificarSubtotales();
        
        $(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
    } else {
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Error al ingresar el detalle, revisar los datos del artículo',
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
    }
    evaluar();
}


// Función para validar si el código ya existe
  function codigoYaExiste(codigo) {
    let existe = false;
    $("input[name='codigo[]']").each(function () {
        if ($(this).val() === codigo) {
            existe = true;
        }
    });
    return existe;
  }

function validarStock(elemento) {
      const stock = parseFloat($(elemento).data('stock'));
      const cantidad = parseFloat($(elemento).val());

      if (cantidad > stock) {
            Swal.fire({
              icon: 'error',
              title: 'Cantidad excedida',
              text: `La cantidad no puede exceder el stock disponible (${stock}).`,
              confirmButtonText: 'Aceptar',
              timer: 3000
          });
          $(elemento).val(stock); // Ajustar al valor máximo permitido
      }
}

function modificarSubtotales() {
      const cantidades = document.getElementsByName("cantidad[]");
      const precios = document.getElementsByName("precio_venta[]");
      const subtotales = document.getElementsByName("subtotal");
      let totalSubtotal = 0;
      let igv = 0;
      let gravado = 0;
      var total = 0.0;
      for (let i = 0; i < cantidades.length; i++) {
            // Convierte los valores de cantidad y precio a números o usa 0 si están vacíos
        const cantidad = parseFloat(cantidades[i].value) || 0;
        const precio = parseFloat(precios[i].value) || 0;

        // Calcula el subtotal
        const subtotal = parseFloat(cantidad * precio);

        // Actualiza el valor del subtotal
        subtotales[i].value = subtotal.toFixed(2);
        document.getElementsByName("subtotal")[i].innerHTML=(subtotal).toFixed(2); // Usa value en lugar de textContent
        totalSubtotal += parseFloat(subtotales[i].value) || 0;
        //gravado = total / 1.18
        //igv = gravado * 0.18;

        total += subtotal;
        gravado = total / 1.18
        igv = gravado * 0.18;
        //totalGravado += parseFloat(subtotales[i].value /1.18);
        //totalIgv += parseFloat(totalGravado * 0.18);
      
      }

      document.getElementById("subtotal_total").value = gravado.toFixed(2);
      document.getElementById("total_igv").value = igv.toFixed(2);
      document.getElementById("total_venta").value = total.toFixed(2);
      // Llama a la función para calcular los totales generales
      
}


function evaluar() {
    if (detalles > 0) {
        $("#btnGuardar").show();
    } else {
        $("#btnGuardar").hide();
        cont = 0;
    }
}

function eliminarDetalle(indice) {
    $(`#fila${indice}`).remove();
    detalles--;
    modificarSubtotales();
    calcularTotales();
}

const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/venta.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Venta Registrado") || datos.includes("Venta Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Venta Registrado") || datos.includes("Venta Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function eliminar(idcaja) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/caja.php?op=eliminar", { idcaja: idcaja }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La caja ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La caja está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idventa = urlParams.get('idventa');

  if (idventa) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/venta.php?op=mostrar", { idventa: idventa }, function (data, status) {
        if (status === "success") {
          const response = JSON.parse(data);
          if (response.ventas && response.ventas.length > 0) {
            const venta = response.ventas[0];
            let tipoPago = venta.tipo_pago;
              // Precargar los campos del formulario
              setTimeout(function() {
              $("#idpersona").val(venta.idpersona).trigger('change'); // Actualiza Select2
              $("#tipo_comprobante").val(venta.codigotipo_comprobante).trigger('change');
              $("#tipopago").val(venta.tipo_pago).trigger('change');
            }, 200); // Retrasar ligeramente para asegurarse de que select2 esté inicializado
              $("#fecha_hora").val(venta.fecha_hora);
              $("strong#nrocorrelativo_texto").text(venta.nrocorrelativo);

              if (tipoPago === "2") { // Depósito
                document.getElementById("deposito-fields").style.display = "none";
              } else if (tipoPago === "3") { // Efectivo
                document.getElementById("deposito-fields").style.display = "block";
                setTimeout(function () {
                  $("#idbanco").val(venta.idbanco).trigger('change');
                }, 300);
                $("#nroperacion").val(venta.nroperacion);
              } else {
                document.getElementById("deposito-fields").style.display = "none";
              }
              
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar Venta');
              $("#idtitle").html('<i class="fas fa-plus"></i> Ver Venta')
            } else {
              console.error("No se encontraron datos para la venta.");
          }
          let stock = 0;
          for (var i = 0; i < response.detalles.length; i++) {
            const detalle = response.detalles[i];
            subtotal = parseFloat(detalle.precio * detalle.cantidad);
            stock = parseFloat(detalle.stock);
            var fila = '<tr class="filas" id="fila' + cont + '">' +
                '<td><button type="button" class="btn btn-danger btn-flat btn-xs" onclick="eliminarDetalle(' + cont + ')"><i class="fa fa-trash"></i></button></td>' +
                '<td> <input type="hidden" name="idinventario_ingreso[]" value="' + detalle.idinventario_ingreso + '">'  +
                '<input type="hidden"  name="idproducto[]" value="'+ detalle.idarticulo +'" >' + detalle.articulo + '</td>' +
                '<td><input type="text" class="form-control" readonly value="' + detalle.codigo + '"></td>' +
                '<td><input type="text"  class="form-control" readonly value="' + detalle.marca + '"></td>' +
                '<td><input type="text" class="form-control" readonly value= "' + detalle.mac + '"></td>' +
                '<td><input type="number" class="form-control" name="cantidad[]" id="cantidad' +cont+'"  value="' + detalle.cantidad_venta + '"  data-stock="'+ stock +'"  data-cantidad-inicial="' + detalle.cantidad_venta + '"></td>' +
                '<td><input type="number" class="form-control" step="0.01" readonly name="precio_compra[]" id="precio_compra' +cont+'" value="' + parseFloat(detalle.precio_compra) + '">'+
                '<td><input type="number" class="form-control" step="0.01" name="precio_venta[]" id="precio_venta' +cont+'" value="' + parseFloat(detalle.precio_venta) + '">'+
                '<td> <span name="subtotal" id="subtotal' +cont+'" ></span></td>' ;
               
            fila += '</tr>'; // Cerrar la fila
            $('#detalles tbody').append(fila);
        
            $(`#cantidad${cont}`).on('keyup change', function () {
              validarStock1(this);
              modificarSubtotales();
              });
    
            $(`#cantidad${cont}, #precio_venta${cont}`).on('keyup change', modificarSubtotales);

            cont++;
            modificarSubtotales();
        }


          } else {
              console.error("Error al cargar los datos");
          }

      });
  }
  function validarStock1(elemento) {
    const stockActual = parseFloat($(elemento).data('stock')); // Stock actual del response
    const cantidadRegistrada = parseFloat($(elemento).val()); // Cantidad actual ingresada en el input
    const cantidadInicial = parseFloat($(elemento).attr('data-cantidad-inicial')) || 0; // Cantidad ya registrada (traída del response)
    
    // Sumar la cantidad inicial registrada al stock actual
    const stockTotal = stockActual + cantidadInicial;

    if (cantidadRegistrada > stockTotal) {
        Swal.fire({
            icon: 'error',
            title: 'Cantidad excedida',
            text: `La cantidad no puede exceder el stock disponible (${stockTotal}).`,
            confirmButtonText: 'Aceptar',
            timer: 3000
        });
        $(elemento).val(stockTotal); // Ajustar al valor máximo permitido
    }
}
});



init();