<?php
ob_start();
session_start();

if (!isset($_SESSION["nombre"]))
{
  header("Location: index.php");
}
else
{
    require '../header.php';

if($_SESSION['ubicacion']==1){

?>
            
            <!-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA&libraries=places"></script> -->
            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA&libraries=places,drawing"></script>


            <div class="content-wrapper">
                <!-- Breadcrumb Section -->
                <section class="content-header">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-sm-12">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item">
                                            <a href="#"><i class="fas fa-home"></i> Panel</a>
                                        </li>
                                        <li class="breadcrumb-item active" aria-current="page">
                                            <a href="list.php">
                                                <i class="module-icon"></i> Ubicacion 
                                            </a>
                                        </li>
                                    </ol>
                                </nav>
                            </div>
                          
                            <div class="col-sm-12" style="margin-top: 20px;">
                                <div class="card ">
                                    <div class="card-header bg-primary">
                                        <h3 class="card-title">
                                            <i class="fas fa-search"></i>
                                         
                                        </h3>
                                    </div>
                                   
                                    <div class="card-body" style="display: block;">
                                        <div class="container-fluid">
                                            <div class="card shadow border" style="padding: 15px; margin-bottom: 20px;">
                                                <div class="row">
                                                    
                                                    <!-- Columna del mapa -->
                                                    <div class="col-sm-7">
                                                    <br>
                                                        <!-- Campo de búsqueda -->
                                                        <div class="form-group input-group">
                                                            
                                                        </div>
                                                        <!-- Mapa -->
                                                        <div id="map" style="width: 100%; height: 600px; margin-top: 10px;"></div>
                                                    </div>

                                                </div>
                                            </div>
                                            <strong id="latitud"></strong>  <strong id="longitud"></strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>                
            </div>



               
            
<?php
}
require '../footer.php';
?>
  <script>
    let map, marker, geocoder;
   
// 📌 Función principal para inicializar el mapa
function initMap() {
    geocoder = new google.maps.Geocoder();

    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            (position) => {
                console.log("Ubicación obtenida:", position.coords.latitude, position.coords.longitude);
                mostrarMapa(position.coords.latitude, position.coords.longitude);
                obtenerBanco(); 
            },
            (error) => {
                if (error.code === error.PERMISSION_DENIED) {
                    Swal.fire({
                        icon: "warning",
                        title: "Acceso denegado",
                        text: "Has bloqueado la geolocalización. Actívala en la configuración del navegador o introduce una dirección manualmente.",
                        confirmButtonText: "Aceptar"
                    });
                } else {
                    alert("No se pudo obtener la ubicación. Seleccione manualmente.");
                }
                mostrarMapa(-12.0464, -77.0428); // Lima por defecto
                obtenerBanco(); 
            }
        );
    } else {
        alert("Geolocalización no soportada");
        mostrarMapa(-12.0464, -77.0428);
        obtenerBanco(); 
    }
}

function obtenerBanco() {
    fetch("obtener_banco.php")
        .then(response => response.json())
        .then(bancos => {
            if (!map) {
                console.error("Mapa no inicializado");
                return;
            }
            bancos.forEach(banco => {
            geocoder.geocode({ address: banco.direccion }, (results, status) => {
              if (status === "OK") {
                const marker = new google.maps.Marker({
                  map: map,
                  position: results[0].geometry.location,
                  title: banco.nombre
                });

                const infowindow = new google.maps.InfoWindow({
                  content: `<strong>${banco.nombre}</strong><br>${banco.direccion}`
                });

                marker.addListener("click", () => {
                  infowindow.open(map, marker);
                });

                // Puedes abrirlo también al pasar el mouse (opcional)
                marker.addListener("mouseover", () => {
                  infowindow.open(map, marker);
                });

                marker.addListener("mouseout", () => {
                  infowindow.close();
                });

              } else {
                console.error("Geocodificación fallida para " + banco.nombre + ": " + status);
              }
            });
          });
        });
        
}

// 📌 Función para mostrar y configurar el mapa
function mostrarMapa(lat, lng) {
    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat, lng },
        zoom: 15
    });

    marker = new google.maps.Marker({
        position: { lat, lng },
        map,
        draggable: true,
        title: "Mueve para seleccionar un punto"
    });

    // 📌 Evento cuando se mueve el marcador
    marker.addListener('dragend', function () {
        let position = marker.getPosition();
        actualizarCoordenadas(position.lat(), position.lng());
    });
}
// Inicializa el mapa cuando se cargue la página
google.maps.event.addDomListener(window, 'load', initMap);
  </script> 

<?php 
}
ob_end_flush();
?>
   