<?php
date_default_timezone_set('America/Lima');
require_once "../../reportes/numeroALetras.php";
include "../fpdf/fpdf.php";
require "../../config/Conexion.php"; 

$idpago = $_GET['idcuota']; 
$sql = "SELECT p.fecha_cancelacion, 
               p.monto,e.nombre as cliente, e.num_documento, t.tipo, 
               p.idcontrato, 
               p.formapago,
               p.nrorecibo,
               p.montopagado,
               s.nombre_plan,month(p.fechainicial)as mes 
        FROM cuota p
        JOIN contrato o ON o.idcontrato = p.idcontrato
        JOIN persona e ON o.idcliente = e.idpersona 
        JOIN tipo_documento t ON t.idtipo_documento = e.idtipo_documento 
        JOIN planes s ON s.idplan=o.idplan
        WHERE p.idcuota = '$idpago'";
$fila = ejecutarConsultaSimpleFila($sql);

$numeroMes = $fila['mes'];
$meses = [
    1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
    5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
    9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
];

$nombreMes = isset($meses[intval($numeroMes)]) ? $meses[intval($numeroMes)] : '';

$nro = $fila['nrorecibo'];
$cliente = $fila['cliente'];
$fechaOriginal = $fila['fecha_cancelacion'];
$dni = $fila['num_documento'];
$montoTotal = $fila['montopagado'];
$tipo = $fila['formapago'];
$descri = 'Mensualidad';
$plan = $fila['nombre_plan'].''.$nombreMes;
$fechaFormateada = date('d/m/Y', strtotime($fechaOriginal));
$horaFormateada = date('h:i a', strtotime($fechaOriginal));

$gravadas = round($montoTotal / 1.18, 2); 
$totalIgv = round($montoTotal - $gravadas, 2);

$metodo = ($tipo == '2') ? 'EFECTIVO' : (($tipo == '3') ? 'TRANSFERENCIA' : 'OTRO');

$letras = NumeroALetras::convertir($montoTotal);
list($num,$cen)=explode('.',$montoTotal);
$leyenda = $letras.'Y '.$cen.'/100 SOLES';


$sql_empresa="SELECT * FROM configuracion";
$fila_empresa = ejecutarConsultaSimpleFila($sql_empresa);

$razon = $fila_empresa['razon_social'];
$ruc = $fila_empresa['ruc_empresa'];
$direccion = $fila_empresa['direccion_empresa'];
$celular = $fila_empresa['celular'];
$email = $fila_empresa['email'];

$pdf = new FPDF('P', 'mm', array(80, 140));
$pdf->AddPage();

// Logo
$pdf->Image('../../files/logo.png', 25, 5, 30); // Ajustar ruta/logo
$pdf->Ln(8);

// Datos empresa
$pdf->SetFont('Arial','B',8);
$pdf->Cell(60, 4, $razon, 0, 1, 'C');
$pdf->Cell(60, 4, 'RUC: '.$ruc, 0, 1, 'C');
$pdf->SetFont('Arial','',6);
$pdf->Cell(60, 3, $direccion , 0, 1, 'C');
$pdf->Cell(60, 3, 'Telf: '.$celular, 0, 1, 'C');
$pdf->Cell(60, 3, 'Correo: '.$email, 0, 1, 'C');
$pdf->Cell(60, 3, 'Web: www.inntelperu.com', 0, 1, 'C');
$pdf->Ln(2);

// Título boleta
$pdf->SetFont('Arial','B',8);
$pdf->Cell(0, 5, 'TICKET PAGO', 0, 1, 'C');
$pdf->SetFont('Arial','B',9);
$pdf->Cell(0, 3, '001 - ' . $nro, 0, 1, 'C');
$pdf->Ln(1);

// Cliente
$pdf->SetFont('Arial','',7);
$pdf->Cell(0, 7, $cliente, 0, 1, 'C');
$pdf->SetFont('Arial','B',7);
$pdf->Cell(0, 4, 'DNI: ' . $dni, 0, 1, 'C');

// Fecha y hora
$pdf->SetFont('Arial','B',6); // Negrita
$pdf->Cell(21, 3, 'FECHA:', 0, 0, 'C'); // Anchura ajustada para que no colisione con el texto siguiente

$pdf->SetFont('Arial','',6); // Normal
$pdf->Cell(1, 3, $fechaFormateada, 0, 0,'C'); // Fecha

$pdf->SetFont('Arial','',6); // Negrita
$pdf->Cell(27, 3, 'HORA:', 0, 0, 'C'); // HORA label

$pdf->SetFont('Arial','',6); // Normal
$pdf->Cell(1, 3, $horaFormateada, 0, 1, 'C'); // Hora
$pdf->Ln(1);
$pdf->Line(10, $pdf->GetY(), 70, $pdf->GetY());

// Encabezado detalle
$pdf->SetFont('Arial','B',6);
$pdf->Cell(50, 5, 'PLAN CONTRATADO', 0);
$pdf->Cell(20, 5, 'TOTAL', 0, 1);
$pdf->Line(10, $pdf->GetY(), 70, $pdf->GetY());
$pdf->Ln(1);

// Detalle producto
$pdf->SetFont('Arial','',6);
$pdf->Cell(50, 5, substr($plan, 0, 60), 0);
$pdf->Cell(20, 5, number_format($montoTotal, 2), 0, 1);
$pdf->Line(10, $pdf->GetY(), 70, $pdf->GetY());

// Totales
$pdf->Ln(2);
$pdf->SetFont('Arial','B',7);
$pdf->Cell(29, 4, 'TOTAL GRAVADO (S/)', 0);
$pdf->Cell(30, 4, number_format($gravadas, 2), 0, 1, 'R');
$pdf->Cell(29, 4, 'I.G.V (S/)', 0);
$pdf->Cell(30, 4, number_format($totalIgv, 2), 0, 1, 'R');
$pdf->SetFont('Arial','B',8);
$pdf->Cell(29, 4, 'TOTAL (S/)', 0);
$pdf->Cell(30, 4, number_format($montoTotal, 2), 0, 1, 'R');
$pdf->Line(10, $pdf->GetY(), 70, $pdf->GetY());
$pdf->Ln(2);

// Monto en letras
// SON: [LEYENDA]
$pdf->SetFont('Arial','B',6); // Negrita para el label
$pdf->Cell(6, 2, 'SON:', 0, 0);

$pdf->SetFont('Arial','',6); // Normal para el texto
$pdf->MultiCell(0, 2, strtoupper($leyenda));

// FORMA DE PAGO: [METODO]
$pdf->Ln(1);
$pdf->SetFont('Arial','B',6);
$pdf->Cell(20, 2, 'FORMA DE PAGO:', 0, 0);

$pdf->SetFont('Arial','',6);
$pdf->Cell(0, 2, strtoupper($metodo), 0, 1);

$pdf->Ln(4);
$pdf->SetFont('Arial','B',6);
$pdf->Cell(0, 2, '!GRACIAS POR SU PREFERENCIA!', 0, 1, 'C');

$pdf->Output('ticket.pdf', 'I');

?>