<?php
ob_start();
date_default_timezone_set('America/Lima');
require_once "../../reportes/numeroALetras.php";
require "../../config/Conexion.php"; 

$idpago = $_GET['id']; 
$sql = "SELECT p.serie, p.correlativo, p.fecha_pago, 
               p.monto,e.nombre as cliente, e.num_documento, t.tipo, 
               p.idcontrato, p.codigotipo_comprobante, 
               p.tipoingreso, c.tipo_trabajo as concepto,
               s.nombre_plan,month(u.fechainicial)as mes 
        FROM pago p 
        JOIN persona e ON p.idcliente = e.idpersona 
        JOIN tipo_documento t ON t.idtipo_documento = e.idtipo_documento 
        JOIN concepto_ingreso c ON c.idconcepto_ingreso = p.idconcepto_ingreso
        JOIN contrato o ON o.idcontrato = p.idcontrato
        JOIN planes s ON s.idplan=o.idplan
        LEFT JOIN cuota u ON u.idcuota=p.idcuota
        WHERE p.idpago = '$idpago'";
$fila = ejecutarConsultaSimpleFila($sql);

$numeroMes = $fila['mes'];
$meses = [
    1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril',
    5 => 'Mayo', 6 => 'Junio', 7 => 'Julio', 8 => 'Agosto',
    9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
];

$nombreMes = isset($meses[intval($numeroMes)]) ? $meses[intval($numeroMes)] : '';

$nro = $fila['correlativo'];
$cliente = $fila['cliente'];
$fechaOriginal = $fila['fecha_pago'];
$dni = $fila['num_documento'];
$montoTotal = $fila['monto'];
$tipo = $fila['tipoingreso'];
$descri = $fila['concepto'];
$plan = $fila['nombre_plan'] . ' ' . $nombreMes;
$fechaFormateada = date('d/m/Y', strtotime($fechaOriginal));
$horaFormateada = date('h:i a', strtotime($fechaOriginal));

$gravadas = round($montoTotal / 1.18, 2); 
$totalIgv = round($montoTotal - $gravadas, 2);

$metodo = ($tipo == '2') ? 'EFECTIVO' : (($tipo == '3') ? 'TRANSFERENCIA' : 'OTRO');

$letras = NumeroALetras::convertir($montoTotal);
list($num, $cen) = explode('.', number_format($montoTotal, 2, '.', ''));
$leyenda = $letras . 'Y ' . $cen . '/100 SOLES';

$sql_empresa = "SELECT * FROM configuracion";
$fila_empresa = ejecutarConsultaSimpleFila($sql_empresa);

$razon = $fila_empresa['razon_social'];
$ruc = $fila_empresa['ruc_empresa'];
$direccion = $fila_empresa['direccion_empresa'];
$celular = $fila_empresa['celular'];
$email = $fila_empresa['email'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Boleta de Venta Electrónica</title>
  <style>
    @page {
      size: A4;
      margin: 20mm;
    }
    body {
      font-family: Arial, sans-serif;
      font-size: 12px;
      margin: 0;
      padding: 0;
    }
    .container {
      width: 100%;
      box-sizing: border-box;
    }
    .header-table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 10px;
    }
    .section {
      border: 1px solid #000;
      padding: 10px;
      margin-top: 10px;
    }
    .section table {
      width: 100%;
    }
    .section td {
      padding: 4px 6px;
      vertical-align: top;
    }
    .items {
      width: 100%;
      border-collapse: collapse;
      table-layout: fixed;
    }
    .items thead th,
    .items tbody td {
      border: 1px solid #000;
      padding: 5px;
    }
    .footer {
      width: 100%;
      margin-top: 10px;
      clear: both;
    }
    .qr {
      width: 60%;
      display: inline-block;
      font-weight: bold;
    }
    .totals {
      width: 39%;
      display: inline-block;
      text-align: right;
      vertical-align: top;
    }
    .totals p {
      margin: 2px 0;
    }
  </style>
</head>
<body>
  <div class="container">
    <table class="header-table">
      <tr>
        <td style="width: 20%;">
          <img src="https://new.inntelperu.com/template/files/logo.png" alt="Logo" height="50">
        </td>
        <td style="width: 50%; text-align: center;">
          <h2 style="margin: 0;"><?php echo $razon; ?></h2>
          <p style="margin: 2px 0;"><?php echo $razon; ?></p>
          <p style="margin: 2px 0;"><?php echo $direccion; ?></p>
          <p style="margin: 2px 0;">Teléf: <?php echo $celular; ?></p>
          <p style="margin: 2px 0;">Email: <?php echo $email; ?></p>
        </td>
        <td style="width: 30%; text-align: center; border: 1px solid #000; border-radius: 8px; padding: 5px;">
          <p style="margin: 5px 0;">R.U.C. <?php echo $ruc; ?></p>
          <h3 style="margin: 5px 0;">FACTURA DE VENTA ELECTRONICA</h3>
          <p style="margin: 5px 0;"><strong>N° <?php echo $fila['serie'] . ' - ' . $nro; ?></strong></p>
        </td>
      </tr>
    </table>

    <div class="section">
      <table>
        <tr>
          <td><strong>Cliente:</strong></td>
          <td><?php echo $cliente; ?></td>
        </tr>
        <tr>
          <td><strong>DNI:</strong></td>
          <td><?php echo $dni; ?></td>
        </tr>
        <tr>
          <td><strong>Fecha:</strong></td>
          <td><?php echo $fechaFormateada . ' ' . $horaFormateada; ?></td>
        </tr>
        <tr>
          <td><strong>Medio de Pago:</strong></td>
          <td><?php echo $metodo; ?></td>
        </tr>
      </table>
    </div>

    <table class="items">
      <thead>
        <tr>
          <th style="width: 20%;">CANTIDAD</th>
          <th style="width: 60%;">DESCRIPCIÓN</th>
          <th style="width: 20%;">IMPORTE (Inc. IGV)</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>1</td>
          <td><?php echo $plan; ?></td>
          <td style="text-align: right"><?php echo number_format($montoTotal, 2); ?></td>
        </tr>
        <tr class="fill-space">
          <td colspan="3">&nbsp;</td>
        </tr>
      </tbody>
    </table>

    <div class="footer">
      <div class="qr">
        <p>SON: <?php echo $leyenda; ?></p>
      </div>
      <div class="totals">
        <p>OP. GRAVADA (S/): <?php echo number_format($gravadas, 2); ?></p>
        <p>TOTAL IGV (S/): <?php echo number_format($totalIgv, 2); ?></p>
        <p><strong>IMPORTE TOTAL (S/): <?php echo number_format($montoTotal, 2); ?></strong></p>
      </div>
    </div>
  </div>
</body>
</html>

<?php
$html = ob_get_clean();

require_once '../../reportes/libreria/dompdf/autoload.inc.php';
use Dompdf\Dompdf;

$dompdf = new Dompdf();
$options = $dompdf->getOptions();
$options->set(['isRemoteEnabled' => true]);
$dompdf->setOptions($options);

$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("factura_electronica.pdf", array("Attachment" => false));
?>