<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Boleta Electrónica</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      width: 80mm;
      margin: 0 auto;
      padding: 10px;
      font-size: 12px;
    }

    .center { text-align: center; }
    .bold { font-weight: bold; }
    .logo img {
      width: 80px;
      margin-bottom: 5px;
    }

    hr { border: 0; border-top: 1px dashed #000; margin: 8px 0; }

    .datos-empresa, .cliente, .items, .totales, .footer {
      margin-bottom: 8px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    .items td, .items th {
      border: 1px solid black;
      padding: 3px;
      font-size: 11px;
      text-align: center;
    }

    .totales td {
      padding: 2px;
      font-size: 12px;
    }

    .qr {
      text-align: center;
      margin-top: 10px;
    }

    .qr img {
      width: 90px;
    }

    .footer small {
      display: block;
      text-align: center;
      font-size: 10px;
      margin-top: 8px;
    }
  </style>
</head>
<body>

  <div class="center logo">
    <img src="https://i.imgur.com/ZB2w4YO.png" alt="Logo Empresa">
  </div>

  <div class="center datos-empresa">
    <div class="bold">DEMOMIFACT</div>
    <div class="bold">EMPRESA DEMO SAC</div>
    <div>RUC: 20101001000</div>
    <div>CALLE LAS NORMAS 123</div>
    <div>Telf: 987 654 321</div>
    <div>Correo: Administrador@facturas.net</div>
    <div>Web: www.facturas.net</div>
  </div>

  <hr>

  <div class="center bold">
    BOLETA DE VENTA ELECTRÓNICA<br>
    B002 - 10300686
  </div>

  <div class="cliente">
    <div><strong>CAMILO SANCHEZ</strong></div>
    <div>DNI 71262017</div>
    <div>FECHA: 06/03/2024 &nbsp;&nbsp; HORA: 11:27 AM</div>
  </div>

  <div class="items">
    <table>
      <thead>
        <tr>
          <th>Cant</th>
          <th>U.M</th>
          <th>COD</th>
          <th>PRECIO</th>
          <th>TOTAL</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>1</td>
          <td>UNIDAD</td>
          <td>98100070005004</td>
          <td>20.00</td>
          <td>20.00</td>
        </tr>
        <tr>
          <td colspan="5" style="text-align:left;">POLO BASICO TALLA SMALL</td>
        </tr>
      </tbody>
    </table>
  </div>

  <div class="totales">
    <table>
      <tr>
        <td style="text-align:right;">TOTAL GRAVADO (S/)</td>
        <td style="text-align:right;">16.95</td>
      </tr>
      <tr>
        <td style="text-align:right;">I.G.V (S/)</td>
        <td style="text-align:right;">3.05</td>
      </tr>
      <tr>
        <td style="text-align:right;" class="bold">TOTAL (S/)</td>
        <td style="text-align:right;" class="bold">20.00</td>
      </tr>
    </table>
    <div><strong>SON:</strong> VEINTE CON 00/100 SOLES</div>
    <div><strong>FORMA DE PAGO:</strong> EFECTIVO</div>
    <div><strong>COND.VENTA:</strong> CONTADO</div>
    <div><strong>Observaciones:</strong></div>
  </div>

  <div class="qr">
    <img src="https://api.qrserver.com/v1/create-qr-code/?data=https://www.mifact.net&size=100x100" alt="QR Código">
  </div>

  <div class="footer">
    <small>Representación Impresa de la BOLETA DE VENTA ELECTRÓNICA</small>
    <small>Puede consultar en: www.MIFACT.net</small>
    <small>Autorizado mediante Resolución 034-005-0007241</small>
  </div>

</body>
</html>


<?php 
$html=ob_get_clean();
//echo $html;

require_once '../../reportes/libreria/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
$dompdf = new Dompdf();

$options = $dompdf->getOptions();
$options->set(array('isRemoteEnabled' => true));
$dompdf->setOptions($options);

$dompdf->setPaper([0, 0, 226.77, 1000]); // Alto grande para evitar cortes

$dompdf->loadHtml($html);
$dompdf->render();
//$dompdf->set

$dompdf->render();
$dompdf->stream("ficharetorno.pdf",array('Attachment' => false));

?>