<?php 
require ("../config/Conexion.php");
session_start();
if(strlen(session_id()) < 1)
// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}

date_default_timezone_set('America/Lima'); 
$idusuario=$_SESSION["idusuario"];
$query_verificar = "SELECT count(idverificar)as con FROM verificar_cuota WHERE estado='1'";
$fila = ejecutarConsultaSimpleFila($query_verificar);
$numero_cuota = $fila['con'];

$query_verificar_incidencia = "SELECT count(idincidencia)as inc FROM incidencia WHERE estado='1'";
$fila_inci = ejecutarConsultaSimpleFila($query_verificar_incidencia);
$numero_incidencia = $fila_inci['inc'];

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <title>Inntel Peru - Panel</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="">
    <meta name="author" content="Author Name">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="shortcut icon" href="#"/>

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="../static/lib/datatables-1.10.25/css/dataTables.bootstrap4.min.css"/>
    <link rel="stylesheet" href="../static/lib/datatables-1.10.25/plugins/responsive-2.2.9/css/responsive.bootstrap4.min.css"/>

    <!--CSS-->
    <link rel="stylesheet" href="../static/lib/bootstrap-4.6.0/css/bootstrap.min.css"/>
    <link rel="stylesheet" href="../static/lib/fontawesome-6.1.1/css/all.min.css"/>
    <link rel="stylesheet" href="../static/lib/jquery-ui-1.12.1/jquery-ui.css"/>

     <!--Javascript-->
    <script src="../static/lib/bootstrap-4.6.0/js/jquery.min.js"></script>
    <script src="../static/lib/jquery-ui-1.12.1/jquery-ui.min.js"></script>
    <script src="../static/lib/bootstrap-4.6.0/js/popper.min.js"></script>
    <script src="../static/lib/bootstrap-4.6.0/js/bootstrap.min.js"></script>
    <script src="../static/lib/adminlte-3.2.0/js/adminlte.min.js"></script>

    <!--Template-->
    <link rel="stylesheet" href="../static/lib/adminlte-3.2.0/css/adminlte.css"/>
    <!--Styles-->
    <link rel="stylesheet" href="../static/css/style.css"/>
   <!--Libs-->
    <script src="../static/lib/bootstrap-daterangepicker-3.1/js/moment.min.js"></script>
    <script src="../static/lib/bootstrap-daterangepicker-3.1/js/moment-with-locales.js"></script>
    <script src="../static/lib/jquery-confirm-3.3.4/js/jquery-confirm.min.js"></script>
    <link rel="stylesheet" href="../static/lib/jquery-confirm-3.3.4/css/jquery-confirm.min.css"/>
    <script src="../static/lib/sweetalert2-11.0.16/js/sweetalert2.all.min.js"></script>
    <link rel="../stylesheet" href="static/lib/sweetalert2-11.0.16/css/sweetalert2.min.css"/>
    <script src="../static/lib/jquery-loading-overlay-2.1.7/js/loadingoverlay.min.js"></script>
    <script src="../static/js/functions.js"></script>
    <script src="../static/lib/highcharts-9.1.1/highcharts.js"></script>
    <script src="../static/lib/highcharts-9.1.1/highcharts-3d.js"></script>
    <script src="../static/lib/highcharts-9.1.1/modules/exporting.js"></script>
    <script src="../static/lib/highcharts-9.1.1/modules/data.js"></script>
    <script src="../static/lib/highcharts-9.1.1/modules/drilldown.js"></script>


</head>

<body data-view="dashboard" class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <!-- Header Template -->
        <header>
            <!-- Include the contents of 'vtc_header.html' -->
            <nav class="main-header navbar navbar-expand navbar-dark bg-primary">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link cursor-pointer collapsedMenu" id="collapsedMenu" data-widget="pushmenu">
                            <i class="fas fa-bars"></i>
                        </a>
                    </li>
                    <li class="nav-item d-none d-sm-inline-block">
                        <a href="index.php" class="nav-link">Inicio</a>
                    </li>
                </ul>
                <ul class="navbar-nav ml-auto d-flex align-items-center flex-wrap">
                    <?php
                    if ($_SESSION['escritorio']==1 and $_SESSION['nombrecargo']=='Administrador' and  $_SESSION['nombrecargo']=='Logistico' and $_SESSION['nombrecargo']=='Asistente'){
                    ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="incidencia/list.php">
                            Notificacion Incidencia
                            <span class="badge badge-success right"><?php echo $numero_incidencia ;?></span></p>
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="pago/list_pago_verificar.php">
                            Notificacion Pago
                            <span class="badge badge-danger right"><?php echo $numero_cuota ;?></span></p>
                        </a>
                    </li>
                    <?php
                    }
                    ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-toggle="dropdown" aria-expanded="false">
                            <i class="far fa-user"></i> Usuario: <?php echo $_SESSION['nombre']; ?>
                        </a>

                       
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right" style="left: inherit; right: 0;">
                            <span class="dropdown-header">Datos de tu conexión</span>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item">
                                <p class="text-sm">Dirección IP</p>
                                <p class="text-sm text-muted">127.0.0.1</p>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item">
                                <p class="text-sm">Dispositivo</p>
                                <p class="text-sm text-muted">Navegador Web</p>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item">
                                <p class="text-sm">Perfil actual</p>
                                <p class="text-sm text-muted">PerfilEjemplo</p>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item">
                                <p class="text-sm">Último acceso</p>
                                <p class="text-sm text-muted">2024-11-12 15:30</p>
                            </a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-toggle="dropdown">
                        <i class="fa-solid fa-user-shield"></i> Perfil: <?php echo $_SESSION['nombrecargo']; ?>
                        </a>
                         <div class="dropdown-menu dropdown-menu-right">
                        <a href="#" class="dropdown-item">Otro Perfil</a>
                        </div>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link btnLogout" href="../ajax/usuario.php?op=salir">
                            <i class="fas fa-power-off"></i>
                        </a>
                    </li>
                </ul>
            </nav>
        </header>

        <!-- Sidebar Template -->
        <aside class="main-sidebar elevation-2 sidebar-dark-primary">
            <a href="index.php" class="brand-link">
                <img src="../media/logo.png" alt="Logo" class="brand-image" style="opacity: .8">
                <span class="brand-text font-weight-light">Empresa Inntel</span>
            </a>
            <div class="sidebar">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="../media/empty.png" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a class="d-block"><?php echo $_SESSION['nombre']; ?></a>
                    </div>
                </div>
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                        <li class="nav-header">Módulos</li>
                        <!-- Module Types Loop -->
                        <?php 
                         if($_SESSION['torre']==1){
                            echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                <a class="nav-link" data-name="module_header">
                                    <i class="nav-icon icon-class fa-solid fa-tower-cell"></i>
                                    <p>Torres y Repetidoras <i class="right fas fa-angle-left"></i></p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <!-- Module Items Loop -->
                                    <li class="nav-item">
                                        <a href="'. BASE_URL .'torre/list.php" class="nav-link" data-name="submodule" data-id="1">
                                            <i class="icon-class nav-icon far fa-circle"></i>
                                            <p>Torre</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="'. BASE_URL .'repetidora/list.php" class="nav-link" data-name="submodule" data-id="1">
                                            <i class="icon-class nav-icon far fa-circle"></i>
                                            <p>Repetidoras</p>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="'. BASE_URL .'ip/list.php" class="nav-link" data-name="submodule" data-id="1">
                                            <i class="icon-class nav-icon far fa-circle"></i>
                                            <p>Ips</p>
                                        </a>
                                    </li>
                                    <!-- Additional Modules as needed -->
                                </ul>
                            </li>';
                            }
    
                            if($_SESSION['mikrotik']==1){
                                echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                    <a class="nav-link" data-name="module_header">
                                        <i class="nav-icon icon-class fa-solid fa fa-wifi"></i>
                                        <p>Mikrotik <i class="right fas fa-angle-left"></i></p>
                                    </a>
                                    <ul class="nav nav-treeview">
                                        <!-- Module Items Loop -->
                                        <li class="nav-item">
                                            <a href="'. BASE_URL .'mikrotik/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                <i class="icon-class nav-icon far fa-circle"></i>
                                                <p>Mikrotik</p>
                                            </a>
                                        </li>                                    
                                    </ul>
                                </li>';
                                }
    
                                if($_SESSION['almacen']==1){
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-boxes"></i>
                                            <p>Almacen <i class="right fas fa-angle-left"></i><span class="badge badge-success right">7</span></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'almacen/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Almacen</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'movimiento/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Transferencia Productos</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'producto/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Producto</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'inventarioingreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Inventario Ingreso</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'inventariosalida/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Inventario Salida</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'inventarioretorno/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Retorno Producto</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'movimiento/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Movimiento Material</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'movimiento/list_acta.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Movimiento Nro Acta</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'inventariogeneral/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Inventario General</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'garantia/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Producto Garantia</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'kardex/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Kardex</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'categoria/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Categoria</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                    </li>';
                                    }
    
                                if($_SESSION['compras']==1){
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-chart-bar"></i>
                                            <p>Compra <i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'compra/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Ingresos</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'proveedor/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Proveedores</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                    </li>';
                                    }
    
                                    if($_SESSION['ventas']==1 and $_SESSION['nombrecargo']=='Administrador'){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fa-shopping-cart"></i>
                                                <p>Venta <i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'venta/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Venta</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                        }
                                        if($_SESSION['ventas']==1 and $_SESSION['nombrecargo']=='Venta'){
                                            echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fa-shopping-cart"></i>
                                                <p>Venta <i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'venta/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Venta</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'abrir_caja/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Abrir Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cerrar_caja/create.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Cerrar Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                        }

                                    if($_SESSION['contratos']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fa fa-file"></i>
                                                <p>Contrato <i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'contrato/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Contrato</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'contrato/list_negra.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Lista Negra Contrato</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                        }
                                if($_SESSION['pago']==1){
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fas fa-calculator"></i>
                                            <p>Pago <i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'pago/list_pago_verificar.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Pago por Verificar</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'pago/list_pendiente_pago.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Pendiente Pago</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                               <a href="'. BASE_URL .'pago/list_recaudo.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                       <p>Recaudo Caja Huancayo</p>
                                                </a>
                                            </li>  
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'pago/pendiente_actualizar.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Pendiente Actualizar Linea</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'pago/list_llamada.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Lista Llamada</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                    </li>';
                                    }
    
                                if($_SESSION['movimiento']==1){
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fa fa-retweet"></i>
                                            <p>Movimientos <i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'llamada/create.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Llamada</p>
                                                </a>
                                            </li>                                        
                                        </ul>
                                    </li>';
                                    }
                                if($_SESSION['registro']==1){
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fa fa-folder"></i>
                                            <p>Planes / Banco<i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'servicio/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Servicio</p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'tecnologia/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Tecnologia</p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'olt/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro OLT</p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'plan/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Planes</p>
                                                </a>
                                            </li>  
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'banco/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Banco</p>
                                                </a>
                                            </li>                                  
                                        </ul>
                                    </li>';
                                    }
                                if($_SESSION['cliente']==1){
                                    $contador_cliente = $conexion->query("SELECT count(idpersona) as cliente FROM persona WHERE idtipo_persona='1' AND estado='1'");  
                                    $fila = mysqli_fetch_assoc($contador_cliente);
                                    $numero_cliente = $fila['cliente'];
                                    echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-user-friends"></i>
                                            <p>Clientes<i class="right fas fa-angle-left"></i><span class="badge badge-danger right">'.$numero_cliente.'</span></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'cliente/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Cliente</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'cliente/list_validacion.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Lista Cliente Portal</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'comision/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Personal Comision</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'sorteo/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                  <p>Lista de Sorteo</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                    </li>';
                                    }
                                    if($_SESSION['adicional']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fas fa-folder"></i>
                                                <p>Adicional<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'categoriaingreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Categoria Ingreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'categoriaegreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Categoria Egreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'ingreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Agregar Ingreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'egreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Agregar Egreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                      <a href="'. BASE_URL .'pagar/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Pagar Egreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'imagenes/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Imagenes Slider</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                        }

                                    if($_SESSION['cobertura']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fa-satellite-dish"></i>
                                                <p> Cobertura<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cobertura/create.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Cobertura</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cobertura/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Iconos</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                    }
                                if($_SESSION['averia']==1 and ($_SESSION['nombrecargo']=='Administrador' or $_SESSION['nombrecargo']=='Asistente' or $_SESSION['nombrecargo']=='Logistico')){
                                    echo' <li class="nav-header">MODULO DE AVERIA</li> 
                                    <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-laptop"></i>
                                            <p>Averia<i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'averia/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Trabajos</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                         <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'averia/list_terminados.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Trabajos Terminados</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'averia/list_calificacion.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Calificacion</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'incidencia/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Incidencia</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                    </li>';
                                }if($_SESSION['averia']==1 and $_SESSION['nombrecargo']=='Cuadrilla'){
                                    echo' <li class="nav-header">MODULO DE AVERIA</li> 
                                    <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-laptop"></i>
                                            <p>Averia<i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'averia/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Registro Trabajos</p>
                                                </a>
                                            </li>                                    
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'control_ingreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Control Ingreso</p>
                                                </a>
                                            </li>                                     
                                        </ul>
                                          <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'abrir_caja/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Abrir Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cerrar_caja/create.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Cerrar Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                    </li>';
                                    }
                                    if($_SESSION['facturacion']==1){
                                        echo' <li class="nav-header">MODULO DE FACTURACION</li> 
                                        <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fas fa-line-chart"></i>
                                                <p>Facturacion<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'facturacion/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Pago a Facturacion</p>
                                                    </a>
                                                </li>                                     
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                    <!-- Module Items Loop -->
                                                    <li class="nav-item">
                                                        <a href="'. BASE_URL .'facturacion/list_facturacion.php" class="nav-link" data-name="submodule" data-id="1">
                                                            <i class="icon-class nav-icon far fa-circle"></i>
                                                            <p>Facturacion Completada</p>
                                                        </a>
                                                    </li>                                     
                                                </ul>
                                           
                                        </li>';
                                        }
                                if($_SESSION['ingreso']==1){
                                    echo' <li class="nav-header">MODULO DE INGRESOS</li> 
                                    <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                        <a class="nav-link" data-name="module_header">
                                            <i class="nav-icon icon-class fa-solid fas fa-line-chart"></i>
                                            <p>Ingreso/Egreso<i class="right fas fa-angle-left"></i></p>
                                        </a>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'control_ingreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Control Ingreso</p>
                                                </a>
                                            </li>                                     
                                        </ul>
                                        <ul class="nav nav-treeview">
                                            <!-- Module Items Loop -->
                                            <li class="nav-item">
                                                <a href="'. BASE_URL .'control_egreso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Control Egreso</p>
                                                </a>
                                            </li>                                     
                                        </ul>
                                        <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                      <a href="'. BASE_URL .'pagar/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Pagar Egreso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'abrir_caja/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Abrir Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cerrar_caja/create.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Cerrar Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                    </li>';
                                    }

                                    if($_SESSION['finanzas']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid fas fa-hand-holding-usd"></i>
                                                <p>Finanzas<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'finanza/caja_principal.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Caja Principal</p>
                                                    </a>
                                                 </li>                                     
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'finanza/cajas_cerrada.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Caja Cerradas</p>
                                                    </a>
                                                 </li>                                     
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'finanza/list_pago.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Pendientes Egreso</p>
                                                    </a>
                                                 </li>                                     
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'finanza/reporte_caja.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Reporte Caja</p>
                                                    </a>
                                                 </li>                                     
                                            </ul>
                                        </li>';
                                        }
                                    if($_SESSION['acceso']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid  fas fa-lock"></i>
                                                <p>Acceso<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'usuario/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Usuario</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                             <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'tecnico/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Tecnicos</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                             <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'cuadrilla/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Cuadrillas</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'caja/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Caja</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                    <a href="'. BASE_URL .'permiso/list.php" class="nav-link" data-name="submodule" data-id="1">
                                                        <i class="icon-class nav-icon far fa-circle"></i>
                                                        <p>Permiso</p>
                                                    </a>
                                                </li>                                    
                                            </ul>
                                        </li>';
                                        } 
                                    if($_SESSION['consultac']==1){
                                        echo' <li class="nav-item has-treeview" data-name="module_header" data-id="">
                                            <a class="nav-link" data-name="module_header">
                                                <i class="nav-icon icon-class fa-solid  fas fa-chart-pie"></i>
                                                <p>Reporte<i class="right fas fa-angle-left"></i></p>
                                            </a>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                <a href="'. BASE_URL .'reporte/finanzas.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Reporte Finanzas</p>
                                                </a>
                                                 </li>                                   
                                            </ul>
                                            <ul class="nav nav-treeview">
                                                <!-- Module Items Loop -->
                                                <li class="nav-item">
                                                <a href="'. BASE_URL .'reporte/reporte_torres.php" class="nav-link" data-name="submodule" data-id="1">
                                                    <i class="icon-class nav-icon far fa-circle"></i>
                                                    <p>Reporte Torres x Repetidora</p>
                                                </a>
                                                 </li>                                   
                                            </ul>
                                        </li>';
                                        }if($_SESSION['acceso']==1){
                                            echo' <li class="nav-item">
                                                    <a href="'. BASE_URL .'empresa/create.php?idconfiguracion=1" class="nav-link" data-name="single_module" data-id="">
                                                        <i class="nav-icon fas fa-building"></i>
                                                        <p>Empresa</p>
                                                    </a>
                                                </li> ';
                                        }    
                            ?>           
                                
                    </ul>
                </nav>
            </div>
        </aside>
        <!-- Content Section -->
        <div class="content-wrapper">
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#"><i class="fas fa-home"></i> Panel</a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <a href="#">
                                            <i class="module-icon"></i> Escritorio
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </section>
<?php
if($_SESSION['escritorio']==1 and $_SESSION['nombrecargo']=='Administrador'){

    $contador_proveedor= "SELECT count(idpersona) as cantidadpro FROM persona WHERE estado='1' and idtipo_persona='2'";  
    $fila = ejecutarConsultaSimpleFila($contador_proveedor);
    $numero_proveedor = $fila['cantidadpro'];

    $contador_producto= "SELECT count(idarticulo) as cantidadproducto FROM articulo WHERE estado='1'";  
    $fila = ejecutarConsultaSimpleFila($contador_producto);
    $numero_producto = $fila['cantidadproducto'];
    
    $contador_categoria= "SELECT count(idcategoria) as cantidadcategoria FROM categoria WHERE condicion='1'";  
    $fila = ejecutarConsultaSimpleFila($contador_categoria);
    $numero_categoria = $fila['cantidadcategoria'];

?>
           
            <section class="content">
                <div class="container-fluid">
                    <!-- Your dynamic content goes here -->
                    <div class="row">
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-user-friends"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">
                                    s</span>
                                    <span class="info-box-number"><?php echo $numero_
                                    ; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-truck"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Proveedores</span>
                                    <span class="info-box-number"><?php echo $numero_proveedor; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-truck-loading"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Categorías</span>
                                    <span class="info-box-number"><?php echo $numero_categoria; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-box"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Productos</span>
                                    <span class="info-box-number"><?php echo $numero_producto;?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header border-transparent">
                                    <h3 class="card-title"><i class="fa fa-file"></i> Resumen de Contratos </h3>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table m-0">
                                            <thead>
                                            <tr>
                                                <th>Estado</th>
                                                <th>Total</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>Prueba</td>
                                                    <td>10</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title"><i class="fas fa-box"></i> Stock de Productos</h3>
                                </div>
                                <div class="card-body p-0">
                                    <div id="graph-stock-products" style="height: 57vh;"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title"><i class="fas fa-calendar-check"></i> Compras y Ventas del Año 2025</h3>
                                </div>
                                <div class="card-body p-0">
                                    <div class="container-fluid p-3" id="graph-purchase-vs-sale"></div>
                                </div>
                            </div>
                        </div>


                    </div>
                </section>
            </div>
            
            <?php
}else if ($_SESSION['escritorio']==1 and $_SESSION['nombrecargo']=='Logistico' ){

    $contador_proveedor= "SELECT count(idpersona) as cantidadpro FROM persona WHERE estado='1' and idtipo_persona='2'";  
    $fila = ejecutarConsultaSimpleFila($contador_proveedor);
    $numero_proveedor = $fila['cantidadpro'];

    $contador_producto= "SELECT count(idarticulo) as cantidadproducto FROM articulo WHERE estado='1'";  
    $fila = ejecutarConsultaSimpleFila($contador_producto);
    $numero_producto = $fila['cantidadproducto'];
    
    $contador_categoria= "SELECT count(idcategoria) as cantidadcategoria FROM categoria WHERE condicion='1'";  
    $fila = ejecutarConsultaSimpleFila($contador_categoria);
    $numero_categoria = $fila['cantidadcategoria'];

?>
           
            <section class="content">
                <div class="container-fluid">
                    <!-- Your dynamic content goes here -->
                    <div class="row">
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-user-friends"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">
                                    s</span>
                                    <span class="info-box-number"><?php echo $numero_
                                    ; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-truck"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Proveedores</span>
                                    <span class="info-box-number"><?php echo $numero_proveedor; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-truck-loading"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Categorías</span>
                                    <span class="info-box-number"><?php echo $numero_categoria; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-box"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Productos</span>
                                    <span class="info-box-number"><?php echo $numero_producto;?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title"><i class="fas fa-box"></i> Stock de Productos</h3>
                                </div>
                                <div class="card-body p-0">
                                    <div id="graph-stock-products" style="height: 57vh;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <?php
}else if ($_SESSION['averia']==1 and $_SESSION['nombrecargo']=='Cuadrilla' ){

    $query_configuracion = "SELECT * FROM configuracion";
    $resultado_confi= mysqli_query($conexion, $query_configuracion);
    $row_confi = mysqli_fetch_assoc($resultado_confi);

             $month=date("n");
            $year=date("Y");
            $diaActual=date("j");
             
            # Obtenemos el dia de la semana del primer dia
            # Devuelve 0 para domingo, 6 para sabado
             $diaSemana=date("w",mktime(0,0,0,$month,1,$year))+7;
            # Obtenemos el ultimo dia del mes
             $ultimoDiaMes=date("d",(mktime(0,0,0,$month+1,1,$year)-1));
             
            $meses=array(1=>"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio",
            "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");

?>    
                <section class="content">
                    <div class="container-fluid">
                        <!-- Your dynamic content goes here -->
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-12">
                                <div class="form-group">
                                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                        <strong>Anuncio!</strong> <?php echo $row_confi['descripcion_anuncio']; ?>
                                    </div>
                                </div>
                             </div>

                            <div class="col-md-6">
                                <div class="card">
                                <div class="card-header bg-primary">
                                        <h3 class="card-title">
                                            <i class="fas fa-search"></i>
                                            Trabajos Terminados Por Fecha
                                        </h3>
                                    </div>
                                    <div class="card-body" style="display: block;">
                                        <div class="container-fluid">
                                        <div class="table-responsive">
                                        <caption><?php echo $meses[$month]." ".$year ?></caption>
                                            <table style="width:100%;" class="table table-bordered" >
                                                <tr>
                                                    <th>Lun</th><th>Mar</th><th>Mie</th><th>Jue</th>
                                                    <th>Vie</th><th>Sab</th><th>Dom</th><th style="background-color: yellow;">TOTAL</th>
                                                </tr>
                                                <tr bgcolor="silver">
                                                    <?php 
                                                        // Consulta para obtener trabajos agrupados por día
                                                            $query_fecha = "SELECT DAY(a.fecha_atencion) AS dia, SUM(i.equivalencia) AS total_equivalencia, 
                                                            COUNT(a.idtrabajo) AS total_trabajos
                                                            FROM averia a 
                                                            JOIN concepto_ingreso c ON a.idtrabajo = c.idconcepto_ingreso 
                                                            LEFT JOIN categoria_ingreso i ON a.idcategoria = i.idcategoria_ingreso
                                                            WHERE YEAR(a.fecha_atencion)='$year' 
                                                            AND MONTH(a.fecha_atencion)='$month' 
                                                            AND a.estado_averia='7'  
                                                            AND a.idtecnico='$idusuario' 
                                                            GROUP BY dia";

                                                    $datos_fecha = mysqli_query($conexion, $query_fecha);

                                                    $trabajosPorDia = [];
                                                    while ($row = mysqli_fetch_assoc($datos_fecha)) {
                                                    $dia = $row['dia'];
                                                    $total_trabajos = $row['total_trabajos'];
                                                    $total_equivalencia = $row['total_equivalencia'];

                                                    // Calcular el total de trabajos multiplicado por la equivalencia
                                                    $trabajosPorDia[$dia] = $total_trabajos;
                                                    }

                                                    // Obtener el primer día del mes y el último día del mes
                                                    $primerDiaMes = date('w', strtotime("$year-$month-01")); // Día de la semana (0=Domingo, 1=Lunes, ...)
                                                    $ultimoDiaMes = date('t', strtotime("$year-$month-01")); // Último día del mes

                                                    $primerDiaMes = ($primerDiaMes == 0) ? 7 : $primerDiaMes; // Convertimos Domingo (0) a 7

                                                    echo "<tr>"; // Iniciar la primera fila

                                                    // Imprimir celdas vacías hasta el primer día del mes
                                                    for ($i = 1; $i < $primerDiaMes; $i++) {
                                                    echo "<td></td>";
                                                    }

                                                    $totalSemana = 0; // Acumulador para el total semanal
                                                    $contadorDiaSemana = $primerDiaMes - 1; // Contador de días en la semana

                                                    // Imprimir días del mes con sus respectivos trabajos
                                                    for ($dia = 1; $dia <= $ultimoDiaMes; $dia++) {
                                                    $trabajos = isset($trabajosPorDia[$dia]) ? $trabajosPorDia[$dia] : 0;
                                                    $totalSemana += $trabajos; // Acumular para el total de la semana

                                                    echo "<td style='text-align: center;'>";
                                                    echo "<b>$dia</b><br>";
                                                    echo "<span style='color: blue;'>$trabajos fichas </span>";
                                                    echo "</td>";

                                                    $contadorDiaSemana++;

                                                    // Si llegamos al domingo (7° columna), imprimimos el total y cerramos la fila
                                                    if ($contadorDiaSemana == 7) {
                                                    echo "<td style='text-align: center; font-weight: bold; background-color: #f0f0f0;'>$totalSemana</td>"; // Mostrar total semanal
                                                    echo "</tr><tr>";
                                                    $totalSemana = 0; // Reiniciar el contador para la siguiente semana
                                                    $contadorDiaSemana = 0;
                                                    }
                                                    }

                                                    // Si la última fila no se completó hasta el domingo, se agregan celdas vacías antes de la columna "Total"
                                                    if ($contadorDiaSemana > 0) {
                                                    while ($contadorDiaSemana < 7) {
                                                    echo "<td></td>";
                                                    $contadorDiaSemana++;
                                                    }
                                                    // Mostrar el total al final de la fila
                                                    echo "<td style='text-align: center; font-weight: bold; background-color: #f0f0f0;'>$totalSemana</td>";
                                                    echo "</tr>";
                                                    }
                                                    ?>
                                            </tr>
                                            </table>
                                          </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card">
                                <div class="card-header bg-primary">
                                        <h3 class="card-title">
                                            <i class="fas fa-search"></i>
                                            Trabajos Terminados
                                        </h3>
                                    </div>
                                    <div class="card-body" style="display: block;">
                                        <div class="container-fluid">
                                        <div class="table-responsive">
                                            <table style="width:100%;" class="table table-bordered" >
                                                <thead >                      
                                                    <th>Categorias</th>
                                                    <th>Valorizacion</th>
                                                    <th>Cantidad</th>
                                                    <th>Puntos Adicionales</th> 
                                                    <th>SubTotal Puntos</th>                                                   
                                                </thead>
                                                <tbody>
                                                <?php 
                                               $query = "SELECT DISTINCT i.idcategoria_ingreso, i.nombre, i.equivalencia  
                                                            FROM categoria_ingreso i";
                                                    $categorias = mysqli_query($conexion, $query);
                                                    
                                                    // Inicializar todas las categorías con equivalencia y contador en 0
                                                    $resultados = [];
                                                    $total = 0;
                                                    $total_adicional = 0;
                                                    
                                                    while ($row = mysqli_fetch_assoc($categorias)) {
                                                        $categoria = $row['nombre'];
                                                        $equivalencia = $row['equivalencia'];
                                                        $resultados[$categoria] = [
                                                            'equivalencia' => $equivalencia,
                                                            'total' => 0, // Inicializa en 0
                                                            'adicional' => 0, // Inicializa en 0
                                                            'cantidad' => 0 // Inicializa en 0
                                                        ];
                                                    }
                                                    
                                                    // SEGUNDA CONSULTA: Obtener la cantidad de trabajos por categoría
                                                 
                                                    $query1 = "SELECT i.nombre as categoria, COUNT(a.idtrabajo) as contador, SUM(a.adicional) as adicional
                                                                FROM averia a 
                                                                JOIN concepto_ingreso c ON a.idtrabajo = c.idconcepto_ingreso 
                                                                LEFT JOIN categoria_ingreso i ON a.idcategoria = i.idcategoria_ingreso
                                                                WHERE YEAR(a.fecha_atencion)='$year' 
                                                                AND MONTH(a.fecha_atencion)='$month' 
                                                                AND a.estado_averia='7'  
                                                                AND a.idtecnico='$idusuario' 
                                                                GROUP BY i.nombre";
                                                    
                                                    $datos = mysqli_query($conexion, $query1);
                                                    
                                                    // Llenar los valores con los datos obtenidos y calcular equivalencia * cantidad
                                                    while ($row2 = mysqli_fetch_assoc($datos)) {
                                                        $categoria = $row2['categoria'];
                                                        $cantidad = $row2['contador'];
                                                        $adicional = $row2['adicional'];
                                                       
                                                        
                                                        if (isset($resultados[$categoria])) {
                                                            $equivalencia = $resultados[$categoria]['equivalencia'];
                                                            $resultados[$categoria]['total'] = ($cantidad * $equivalencia) + $adicional; 
                                                            $resultados[$categoria]['adicional'] = $adicional;
                                                            $resultados[$categoria]['cantidad'] = $cantidad;
                                                            $total += $resultados[$categoria]['total']; // Sumar al total general
                                                            $total_adicional += $adicional;
                                                        }
                                                    }
                                                    
                                                    
                                                    // Mostrar todas las categorías
                                                    foreach ($resultados as $categoria => $datos) {
                                                        echo "<tr style=text-align:center;>";
                                                        echo "<td style='border: solid 0.3px #050505'>$categoria</td>";
                                                        echo "<td style='border: solid 0.3px #050505'>" . $datos['equivalencia'] . "</td>";
                                                        echo "<td style='border: solid 0.3px #050505'>" . $datos['cantidad'] . "</td>"; // NUEVO
                                                        echo "<td style='border: solid 0.3px #050505'>" . $datos['adicional'] . "</td>";
                                                        echo "<td style='border: solid 0.3px #050505';>" . $datos['total'] . "</td>";
                                                        echo "</tr>";
                                                    }
                                                
                                                    // Agregar fila de totales
                                                    echo "<tr style='background-color:#40b940; color:white; font-weight:bold; text-align:center;'>";
                                                    echo "<td>TOTAL TRABAJOS</td>";
                                                    echo "<td></td>";
                                                    echo "<td></td>";
                                                    echo "<td></td>";
                                                    echo "<td>$total</td>";
                                                    echo "</tr>";
                                                
                                                ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                </section>
            </div>
 <?php
 }else if ($_SESSION['averia']==1  and $_SESSION['nombrecargo']=='Asistente' and $_SESSION['nombrecargo']=='Venta'){

 }
 ?>
        <!-- Footer Template -->
        <footer class="main-footer">
            <div class="text-center">
                © Copyright <strong>Dashboard New</strong>. Todos los derechos reservados<br>
                <a href="https://wa.me/945091085/?text=Hola%20Jorge%20" target="_blank" target="_blank">Desarrollado por Jorge Melgarejo.</a>
            </div>
        </footer>
    </div>

    <script>
        // Example script for displaying error messages if they exist
        var errors = '';
        // Add messages dynamically here
        if (errors) {
            alert(errors); // Replace with your own error display logic
        }
   
    
    </script>
</body>
<!-- JavaScript for DataTable -->
    <script src="../static/lib/datatables-1.10.25/js/jquery.dataTables.js"></script>
    <script src="../static/lib/datatables-1.10.25/js/dataTables.bootstrap4.min.js"></script>
    <script src="../static/lib/datatables-1.10.25/plugins/responsive-2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="../static/lib/datatables-1.10.25/plugins/responsive-2.2.9/js/responsive.bootstrap4.min.js"></script>
    <script src="../static/js/main.js"></script>
</html>
<script type="text/javascript" src="../scripts/escritorio.js"></script>