<?php 
 include("../../config/Conexion.php");

header("Content-type: application/vnd.ms-excel; charset=iso-8859-1");
header("Content-Disposition: attachment; filename= REPORTEDETALLEINGRESO.xls");

// Sanitización de parámetros
$idingreso = isset($_GET['id']) ? intval($_GET['id']) : 0;

    // Consultar datos para la primera tabla
    $queryIngresos = "
        SELECT d.cantidad, d.precio_venta, d.precio_compra, a.nombre 
        FROM detalle_ingreso d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        WHERE d.idingreso = $idingreso";
    $ingresos = ejecutarConsultaArray($queryIngresos, $conexion);

    // Consultar datos para la segunda tabla
    $queryDetalles = "
        SELECT d.fecha, a.codigo AS codigo_producto, d.codigo AS cod_num, d.mac, d.precio_compra, 
            c.codigo AS cod_categoria, a.nombre 
        FROM inventario_ingreso d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        JOIN categoria c ON a.idcategoria = c.idcategoria 
        WHERE d.iddetalle_ingreso  = $idingreso";
    $detalles = ejecutarConsultaArray($queryDetalles, $conexion);

    // Cerrar la conexión
    $conexion->close();
?>

<div class="panel-body table-responsive" id="listadoregistros">
    <!-- Primera tabla -->
    <table class="table table-hover">
        <tr style="background-color:#4564ff; color:white; font-size:18px;">
            <th>Artículo</th>
            <th>Cantidad</th>
            <th>Precio Compra</th>
            <th>Precio Venta</th>
            <th>Subtotal</th>
        </tr>
        <?php
        $suma = 0;
        foreach ($ingresos as $row) {
            $subtotal = $row['precio_compra'] * $row['cantidad'];
            $suma += $subtotal;
            echo "<tr>
                <td>" . htmlspecialchars($row['nombre']) . "</td>
                <td>" . htmlspecialchars($row['cantidad']) . "</td>
                <td>" . number_format($row['precio_compra'], 2, ".", ",") . "</td>
                <td>" . number_format($row['precio_venta'], 2, ".", ",") . "</td>
                <td>" . number_format($subtotal, 2, ".", ",") . "</td>
            </tr>";
        }
        ?>
        <tr>
            <th colspan="4" style="text-align:right;">TOTAL</th>
            <th colspan="4" style="text-align:right;"><?php echo number_format($suma, 2, '.', ','); ?></th>
        </tr>
    </table>

    <!-- Segunda tabla -->
    <table class="table table-hover">
        <tr style="background-color:#050505; color:white; font-size:18px;">
            <th>Fecha Registro</th>
            <th>Código Categoría</th>
            <th>Código Producto</th>
            <th>Código Num</th>
            <th>MAC</th>
            <th>Nombre</th>
            <th>Precio Individual</th>
        </tr>
        <?php
        foreach ($detalles as $row) {
            $mac = $row['mac'] ?: 'S/N'; // Manejar valores nulos o vacíos
            echo "<tr>
                <td>" . htmlspecialchars($row['fecha']) . "</td>
                <td>" . htmlspecialchars($row['cod_categoria']) . "</td>
                <td>" . htmlspecialchars($row['codigo_producto']) . "</td>
                <td>" . htmlspecialchars($row['cod_num']) . "</td>
                <td>" . htmlspecialchars($mac) . "</td>
                <td>" . htmlspecialchars($row['nombre']) . "</td>
                <td>" . number_format($row['precio_compra'], 2, '.', ',') . "</td>
            </tr>";
        }
        ?>
    </table>
</div>