<?php 
require_once('../../config/Conexion.php');
// Encabezados para el archivo Excel
header("Content-type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=excel_malogrado.xls");
?>
<table border="1" style="border-collapse:collapse; width:100%; font-size:14px;">
    <thead>
        <tr style="background-color:#A9D0F5; text-align:center;">
            <th width="20%">Nombre Producto</th>
            <th>Cod Madre</th>
            <th>Codigo</th>
            <th>Estado Material</th>
            <th>Categoria</th>        
            <th>Unidad Medida</th>         
            <th>Precio Venta</th>                 
            <th>Cantidad Malogrado</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $query = "
            SELECT d.idarticulo,a.nombre 
            FROM inventario_retorno d 
            JOIN articulo a on d.idarticulo=a.idarticulo
            WHERE d.estadomaterial=4 GROUP BY d.idarticulo ORDER BY a.idcategoria desc
            ";

        $result = mysqli_query($conexion, $query);

        while ($row = mysqli_fetch_assoc($result)) {
            $nombre = $row['nombre'];
            $idarti = $row['idarticulo'];
            $sumacant = 0.00;

            echo "<tr style='font-weight:bold; background-color:#CCCCCC; text-align:center;'>";
            echo "<td>{$nombre}</td><td colspan='7'></td>";
            echo "</tr>";

            // Consulta secundaria para detalles del artículo
            $detailQuery = "
                SELECT c.codigo as madre,d.codigo,d.estadomaterial,d.cantidad,a.unidad_medida,d.precio_venta,d.idarticulo,a.nombre,c.nombre as categoria 
                FROM inventario_retorno d 
                JOIN articulo a on d.idarticulo=a.idarticulo 
                JOIN categoria c on a.idcategoria=c.idcategoria 
                WHERE d.idarticulo='$idarti' and d.estadomaterial=4 ORDER BY d.idinventario_retorno desc
            ";

            $detailResult = mysqli_query($conexion, $detailQuery);

            while ($detail = mysqli_fetch_assoc($detailResult)) {
                // Transformar estado del material
                switch ($detail['estadomaterial']) {
                    case 1: $estado = "Nuevo"; break;
                    case 2: $estado = "Usado"; break;
                    case 3: $estado = "Reparado"; break;
                    default: $estado = "Malogrado"; break;
                }

                // Datos del artículo
                $madre = $detail['madre'];
                $codigo = $detail['codigo'];
                $stock = $detail['cantidad'];
                $categoria = $detail['categoria'];
                $unidad = $detail['unidad_medida'];
                $precioVenta = number_format($detail['precio_venta'], 2);

                // Acumular stock
                $sumacant += $stock;

                echo "<tr style='text-align:center;'>";
                echo "<td></td>";
                echo "<td>{$madre}</td>";
                echo "<td>{$codigo}</td>";
                echo "<td>{$estado}</td>";
                echo "<td>{$categoria}</td>";
                echo "<td>{$unidad}</td>";
                echo "<td>{$precioVenta}</td>";
                echo "<td>{$stock}</td>";
                echo "</tr>";
            }

            // Total por artículo
            echo "<tr style='font-size:16px; text-align:center; background-color:#dc3545; color:#FFFFFF;'>";
            echo "<td colspan='6'></td>";
            echo "<td style='text-align:right;'>TOTAL STOCK:</td>";
            echo "<td>{$sumacant}</td>";
            echo "</tr>";
        }
        ?>
    </tbody>
</table>
