<?php
include "../fpdf/fpdf.php";
require "../../config/Conexion.php"; 

$idmaterial = $_GET['id'];

$query = "SELECT u.nombre as usuario, o.nombre as responsable, s.fechasalida, s.idsalida, YEAR(s.created_at) as ano 
          FROM salida s 
          JOIN usuario u ON s.idusuario = u.idusuario 
          JOIN usuario o ON s.idtecnico = o.idusuario  
          WHERE s.idsalida = '$idmaterial'";
$adicional = mysqli_query($conexion, $query);
$row = mysqli_fetch_array($adicional);

$usuario = $row['usuario'];
$responsable = $row['responsable'];
$fecha = $row['fechasalida'];
$correlativo = $row['ano'] . '-00' . $row['idsalida'];

$pdf = new FPDF('P','mm',array(80,160));
$pdf->AddPage();

$pdf->Image('../../files/logo.png', 18, 10, 41, 15);
$pdf->SetY(25);

// DATOS TICKET        
$pdf->SetFont('Arial','B',7);
$pdf->Cell(60,4,'Ticket Salida',0,1,'C');
$pdf->Cell(60,4,'Codigo: '.$correlativo,0,1,'C');
$pdf->SetFont('Arial','B',6);
$pdf->Cell(60,4,'Encargado: '.$usuario,0,1,'C');
$pdf->SetFont('Arial','',5);
$pdf->Cell(60,5,'Fecha Salida: '.$fecha,0,1,'C');

$pdf->Ln(2);
$pdf->SetFont('Arial','B',6);
$pdf->Cell(60,4,'Recepciona: '.$responsable,0,1,'L');
$pdf->Ln(2);

// CABECERA TABLA
$pdf->SetFont('Arial','B',5);
$pdf->Cell(10,4,'#',0,0,'L');
$pdf->Cell(30,4,'Material',0,0,'L');
$pdf->Cell(15,4,'Codigo',0,0,'L');
$pdf->Cell(10,4,'Cant.',0,1,'L');
$pdf->Cell(60,0,'','T',1,'L'); // línea separadora

// DETALLES
$detalle_venta = "SELECT d.codigo, d.cantidad, d.precio_compra, p.nombre 
                  FROM inventario_salida d 
                  JOIN articulo p ON d.idarticulo = p.idarticulo
                  WHERE d.idsalida = '$idmaterial'";

$fila = ejecutarConsulta($detalle_venta);
$pdf->SetFont('Arial','',5);
$index = 1;

foreach($fila as $pro) {
    // Verificamos si se está acabando el espacio y agregamos una nueva página si es necesario
    if($pdf->GetY() > 150){ // 150 mm para dejar margen
        $pdf->AddPage();
        $pdf->SetFont('Arial','B',5);
        $pdf->Cell(10,4,'#',0,0,'L');
        $pdf->Cell(30,4,'Material',0,0,'L');
        $pdf->Cell(15,4,'Codigo',0,0,'L');
        $pdf->Cell(10,4,'Cant.',0,1,'L');
        $pdf->Cell(75,0,'','T',1);
        $pdf->SetFont('Arial','',5);
    }

    $pdf->Cell(10,4,$index++,0,0,'L');
    $pdf->Cell(30,4,$pro["nombre"],0,0,'L');
    $pdf->Cell(15,4,$pro["codigo"],0,0,'L');
    $pdf->Cell(10,4,$pro["cantidad"],0,1,'L');
}

$pdf->Ln(5);
$pdf->SetFont('Arial','',4.5);
$pdf->Cell(60,4,'Comprobante de salidas de los productos',0,1,'C');

$pdf->Output('ticket_salida.pdf','I');
?>
