<?php
echo "\xEF\xBB\xBF"; 
require_once('../../config/Conexion.php');

// Encabezados para el archivo Excel
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=excel_pendiente.xls");
header("Pragma: no-cache");
//header("Expires: 0");

// Variables para las fechas o filtros
$desde = $_GET['fechainicio'] ?? '';
$hasta = $_GET['fechafinal'] ?? '';
$dni = $_GET['dni'] ?? '';

// Consulta principal
if (!empty($desde) && !empty($hasta) && empty($dni)) {
    $query = "SELECT o.nrocontrato,p.nombre as cliente, o.paga, p.celular, p.telefono, p.whatsapp, month(c.fechainicial)as mes, c.fecha_pago, o.sit_contrato, 
              c.fechainicial,c.fechavencimiento,c.monto,t.nombre as tecnologia,o.modalidad,o.fecha_hora,d.address,d.description,r.nombre_torre   
              FROM cuota c 
              JOIN contrato o ON c.idcontrato=o.idcontrato
              JOIN torre r ON o.idtorre=r.idtorre
              JOIN tecnologia t ON o.idtecnologia=t.idtecnologia
              JOIN persona p ON o.idcliente=p.idpersona
              LEFT JOIN detalle_direccion d ON o.iddireccion=d.iddireccion
              WHERE date(c.fecha_pago) BETWEEN '$desde' and '$hasta' AND c.estado_contrato='1' AND c.estado_cuota='1' AND o.sit_contrato!='baja'
              GROUP BY o.idcontrato ORDER BY c.idcuota desc ";


} elseif (empty($desde) && empty($hasta) && !empty($dni)) {
    $query = "SELECT o.nrocontrato,p.nombre as cliente, o.paga, p.celular, p.telefono, p.whatsapp, month(c.fechainicial)as mes, c.fecha_pago, o.sit_contrato,
              c.fechainicial,c.fechavencimiento,c.monto,t.nombre as tecnologia,o.modalidad,o.fecha_hora,d.address,d.description,r.nombre_torre    
              FROM cuota c 
              JOIN contrato o ON c.idcontrato=o.idcontrato
              JOIN torre r ON o.idtorre=r.idtorre
              JOIN tecnologia t ON o.idtecnologia=t.idtecnologia
              JOIN persona p ON o.idcliente=p.idpersona
              LEFT JOIN detalle_direccion d ON o.iddireccion=d.iddireccion
              WHERE p.num_documento='$dni' AND c.estado_contrato='1' AND c.estado_cuota='1' AND o.sit_contrato!='baja'
              GROUP BY o.idcontrato ORDER BY c.idcuota DESC";
} else {
    die("Por favor, proporcione al menos uno de los filtros: rango de fechas o DNI.");
}

$adicional = mysqli_query($conexion, $query);

if (!$adicional) {
    die("Error en la consulta: " . mysqli_error($conexion));
}

// Inicio de la tabla HTML para el archivo Excel
echo "<table border='1'>";
echo "<tr style='background-color:#A9D0F5; text-align:center; font-weight:bold;'>
        <th>Codigo Pago</th>
        <th>Nombre Cliente</th>
        <th>Torre</th>
        <th>Tecnologia</th>
        <th>Modalidad Equipo</th>
        <th>Fecha Contrato</th>
        <th>Direccion</th>
        <th>Pago</th>
        <th>Celular</th>
        <th>WhatsApp</th>
        <th>Nro Cuota/Mes</th>
        <th>Fecha Corte</th>
        <th>Servicio</th>
        <th>Periodo</th>
        <th>Monto</th>
      </tr>";

while ($row = mysqli_fetch_assoc($adicional)) {
  
    $cliente = $row['cliente'];
    $nro = $row['nrocontrato'];
    $paga = $row['paga'];
    $cel = $row['celular'];
    $whasp = $row['whatsapp'];
    $mes = $row['mes'];
    $fecha_pago = $row['fecha_pago'];
    $sit = $row['sit_contrato'];
    $pe = $row['fechainicial']."  a  ".$row['fechavencimiento'];
    $monto = number_format($row['monto'], 2);
    $tecnologia = $row['tecnologia'];
    $modalidad = $row['modalidad'];
    $fecha_hora = $row['fecha_hora'];
    $direccion = $row['address'];
    $descripcion = $row['description'];
    $nombre_torre = $row['nombre_torre'];
   
    echo "<tr style='text-align:center;'>
            <td>$nro</td>
            <td>$cliente</td>
            <td>$nombre_torre</td>
            <td>$tecnologia</td>
            <td>$modalidad</td>
            <td>$fecha_hora</td>
            <td>$direccion'/'$descripcion</td>
            <td>$paga</td>
            <td>$cel</td>
            <td>$whasp</td>
            <td>$mes</td>
            <td>$fecha_pago</td>
            <td>$sit</td>
            <td>$pe</td>
            <td>$monto</td>
            </td>
          </tr>";

}
// Cierre de la tabla
echo "</table>";
mysqli_close($conexion);
?>