<?php
require_once('../../config/Conexion.php');

// Encabezados para el archivo Excel
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=excel_finanza.xls");
header("Pragma: no-cache");
echo "\xEF\xBB\xBF"; 
//header("Expires: 0");

// Variables para las fechas o filtros
$anio = $_GET['anio'] ?? '';
$mes = $_GET['mes'] ?? '';

// Consulta principal
if (!empty($anio) && !empty($mes)) {

    // Obtener todas las categorías de ingreso
    $sql_ingreso = "SELECT idcategoria_ingreso, nombre as categoria FROM categoria_ingreso ORDER BY nombre ASC";
    $resultCabecerai = ejecutarConsulta($sql_ingreso);

    $cabeceras_ingreso = [];
    $detalles_ingreso = [];

    while ($row = $resultCabecerai->fetch_assoc()) {
        $row['total_monto'] = 0; // Inicializamos el monto total en 0
        $cabeceras_ingreso[$row['idcategoria_ingreso']] = $row;
    }

    foreach ($cabeceras_ingreso as $idcategoria_ingreso => &$cabecera_ingreso) {
        // Consulta para obtener los detalles de cada categoría
        $sqldetalle_ingreso = "SELECT c.idconcepto_ingreso, c.tipo_trabajo, SUM(p.monto) AS monto 
                              FROM concepto_ingreso c 
                              LEFT JOIN pago p ON p.idconcepto_ingreso = c.idconcepto_ingreso 
                              AND YEAR(p.fecha_pago)='$anio' 
                              AND MONTH(p.fecha_pago)='$mes'
                              WHERE c.idcategoria_ingreso = '$idcategoria_ingreso' 
                              GROUP BY c.idconcepto_ingreso";
        $resultDetalles_ingreso = ejecutarConsulta($sqldetalle_ingreso);

        $detallesIngreso = [];
        $totalMonto = 0; // Variable para almacenar la suma total por categoría

        while ($rowDetalle = $resultDetalles_ingreso->fetch_assoc()) {
            $rowDetalle['monto'] = $rowDetalle['monto'] ?? 0; // Si el monto es NULL, lo establecemos en 0
            $detallesIngreso[] = $rowDetalle;
            $totalMonto += $rowDetalle['monto']; // Sumamos el monto total
        }

        // Guardamos los detalles en la categoría
        $detalles_ingreso[$idcategoria_ingreso] = $detallesIngreso;
        // Guardamos el monto total en la cabecera de la categoría
        $cabecera_ingreso['total_monto'] = $totalMonto;
    }

    // Obtener todas las categorías de egreso
    $sql_egreso = "SELECT idcategoria_egreso, nombre as categoria FROM categoria_egreso ORDER BY nombre ASC";
    $resultCabecerae = ejecutarConsulta($sql_egreso);

    $cabeceras_egreso = [];
    $detalles_egreso = [];

    while ($rowe = $resultCabecerae->fetch_assoc()) {
        $rowe['total_monto'] = 0; // Inicializamos el monto total en 0
        $cabeceras_egreso[$rowe['idcategoria_egreso']] = $rowe;
    }

    foreach ($cabeceras_egreso as $idcategoria_egreso => &$cabecera_egreso) {
      // Consulta para obtener los detalles de cada categoría
      $sqldetalle_egreso = "SELECT e.idegreso,c.idconcepto_egreso, c.concepto, SUM(e.monto) AS monto,e.descripcion,e.fechapago,b.nombre as banco,e.nroperacion,e.hora,e.nrorecibo,e.tipo_comprobante
                            FROM concepto_egreso c 
                            LEFT JOIN egreso e ON e.idconcepto_egreso = c.idconcepto_egreso
                            LEFT JOIN banco b ON e.idbanco = b.idbanco
                            WHERE c.idcategoria_egreso = '$idcategoria_egreso' AND year(e.fechapago)='$anio' AND month(e.fechapago)='$mes'
                            GROUP BY e.idegreso";
      $resultDetalles_egreso = ejecutarConsulta($sqldetalle_egreso);

      $detallesEgreso = [];
      $totalMontoo = 0; // Variable para almacenar la suma total por categoría

      while ($rowDetallee = $resultDetalles_egreso->fetch_assoc()) {
          // Si el monto es NULL, lo establecemos en 0
          $rowDetallee['monto'] = $rowDetallee['monto'] ?? 0;
          $detallesEgreso[] = $rowDetallee;
          $totalMontoo += $rowDetallee['monto']; // Sumamos el monto total
      }

      // Guardamos los detalles en la categoría
      $detalles_egreso[$idcategoria_egreso] = $detallesEgreso;
      // Guardamos el monto total en la cabecera de la categoría
      $cabecera_egreso['total_monto'] = $totalMontoo;
  }

    // Inicio de la tabla HTML para el archivo Excel
    echo "<table border='1'>";
    echo "<tr style='background-color:#A9D0F5; text-align:center; font-weight:bold;'>
            <tr  height='40'  bgcolor='#F3F3F3'><th style='text-align: center' colspan='3'>INGRESOS FINANZAS</th>
            </tr>
            <th>Item</th>
            <th>Concepto</th>
            <th>Monto</th>
          </tr>";
        
    $item = 1; // Contador de ítems
    $total_general = 0; // Acumulador del total general

    foreach ($cabeceras_ingreso as $idcategoria_ingreso => $cabecera) {
        // Mostrar la cabecera primero
        echo "<tr style='background-color:#D0E9C6; font-weight:bold;'>
                <td>$item</td>
                <td>{$cabecera['categoria']}</td>
                <td>S/".number_format($cabecera['total_monto'], 2)."</td>
              </tr>";

        $total_general += $cabecera['total_monto']; // Sumar al total general

        // Si existen detalles, los mostramos después de la cabecera
        if (!empty($detalles_ingreso[$idcategoria_ingreso])) {
            foreach ($detalles_ingreso[$idcategoria_ingreso] as $detalle) {

                $tipo_trabajo = mb_convert_encoding($detalle['tipo_trabajo'], "UTF-8", "auto");
                echo "<tr style='text-align:center;'>
                        <td></td>
                        <td>{$tipo_trabajo}</td>
                        <td>S/".number_format($detalle['monto'], 2)."</td>
                      </tr>";
            }
        }
        $item++; // Incrementamos el contador
    }
    // Agregar fila con el Total General de ingresos
    echo "<tr style='background-color:#F5B7B1; font-weight:bold;'>
            <td></td>
            <td>Total General de Ingresos</td>
            <td>S/".number_format($total_general, 2)."</td>
          </tr>";

    // Cierre de la tabla
    echo "</table>";

    echo "<table border='1'>";
    echo "<tr style='background-color:#A9D0F5; text-align:center; font-weight:bold;'>
            <tr  height='40' bgcolor='#F3F3F3'><th style='text-align: center' colspan='10'>EGRESO FINANZAS</th>
            </tr>
            <th>Categoria</th>
            <th>Concepto</th>
            <th>Descripcion</th>
            <th>Fecha Pago</th>
            <th>Banco</th>
            <th>Nroperacion</th>
            <th>Hora</th>
            <th>Tipo Comprobante</th>
            <th>Nro Recibo</th>
            <th>Monto</th>
          </tr>";

            $item2 = 1; // Contador de ítems
            $total_generale = 0; // Acumulador del total general

            foreach ($cabeceras_egreso as $idcategoria_egreso => $cabecerae) {
                // Mostrar la cabecera primero
                echo "<tr style='background-color:#D0E9C6; font-weight:bold;'>
                        <td>{$cabecerae['categoria']}</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";

                $total_generale += $cabecerae['total_monto']; // Sumar al total general

                $tiposComprobante = [
                    1 => "Recibo Egreso",
                    2 => "Boleta",
                    3 => "Factura"
                ];
                // Si existen detalles, los mostramos después de la cabecera
                if (!empty($detalles_egreso[$idcategoria_egreso])) {
                    foreach ($detalles_egreso[$idcategoria_egreso] as $detallee) {

                        $tipoComprobanteTexto = $tiposComprobante[$detallee['tipo_comprobante']] ?? "Desconocido";


                        echo "<tr style='text-align:center;'>
                                <td></td>
                                <td>{$detallee['concepto']}</td>
                                <td>{$detallee['descripcion']}</td>
                                <td>{$detallee['fechapago']}</td>
                                <td>{$detallee['banco']}</td>
                                <td>{$detallee['nroperacion']}</td>
                                <td>{$detallee['hora']}</td>
                                <td>{$tipoComprobanteTexto}</td>
                                <td>{$detallee['nrorecibo']}</td>
                                <td>S/".number_format($detallee['monto'], 2)."</td>
                            </tr>";
                    }
                }
                $item++; // Incrementamos el contador
            }
            // Agregar fila con el Total General de ingresos
            echo "<tr style='background-color:#F5B7B1; font-weight:bold;'>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>Total General de Egresos</td>
                    <td>S/".number_format($total_generale, 2)."</td>
                </tr>";

          echo "</table>";
} else {
    echo "<p style='color:red;'>Error: Debes proporcionar un año y un mes válidos.</p>";
}
?>